/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.logging;

import br.com.elotech.logging.mdc.LogFieldsCustomizer;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingFieldsConfigurer
implements LogFieldsCustomizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingFieldsConfigurer.class);
    private final EntidadeContabilidadeService entidadeService;

    public LoggingFieldsConfigurer(EntidadeContabilidadeService entidadeService) {
        this.entidadeService = entidadeService;
    }

    public void customize(Map<String, String> fields) {
        log.info("Iniciando configura\u00e7\u00e3o dos campos da entidade nos logs");
        Optional entidade = this.entidadeService.getEntidadePrincipal();
        if (entidade.isPresent()) {
            fields.put("entidade", ((Entidade)entidade.get()).getNome().toUpperCase(Locale.getDefault()));
            fields.put("entidadeCnpj", ((Entidade)entidade.get()).getCnpj());
        } else {
            log.warn("A entidade padr\u00e3o n\u00e3o est\u00e1 configurada. N\u00e3o ser\u00e1 poss\u00edvel configurar os seus respectivos campos");
        }
    }
}

