/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.UltimaAtualizacaoCustom;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class UltimaAtualizacaoRepository
implements UltimaAtualizacaoCustom {
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public UltimaAtualizacaoRepository(DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<UltimaAtualizacaoDTO> ultimaAtualizacao() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT MODULO, MAX(ULTIMOACESSO) AS ULTIMOACESSO \n");
        sql.append("  FROM ${db.contabilidade.schema}.USRXMOD \n");
        sql.append(" WHERE ULTIMOACESSO IS NOT NULL \n");
        sql.append(" GROUP BY MODULO");
        return this.datasourceWrapper.getSimpleJdbcTemplate().query(sql.toString(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }

    public UltimaAtualizacaoDTO getUltimaAtualizacao(String table, String column, Long entidade) {
        List listResult = this.datasourceWrapper.getSimpleJdbcTemplate().query(SqlUtils.createSQLUltimaAtualizacaoByTableAndColumn((String)("${db.contabilidade.schema}." + table), (String)column, (Long)entidade), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
        return listResult.stream().findFirst().orElse(new UltimaAtualizacaoDTO());
    }
}

