/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.contabilidade.client.dto.CentralPagamentoDTO;
import br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoDTO;
import br.com.elotech.contabilidade.client.dto.DiariaMovimentacaoDocumentoDTO;
import br.com.elotech.contabilidade.client.dto.DotacaoDTO;
import br.com.elotech.contabilidade.client.dto.EmpenhoDTO;
import br.com.elotech.contabilidade.client.dto.ExercicioDTO;
import br.com.elotech.contabilidade.client.dto.LiquidacaoDTO;
import br.com.elotech.contabilidade.client.dto.PessoaDTO;
import br.com.elotech.contabilidade.client.dto.UnidadeDTO;
import br.com.elotech.core.utils.NumberUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdiantamentoPessoalDTO {
    private Long entidade;
    private Long exercicio;
    private Long prestacaoContas;
    private String nome;
    private LocalDate dataPrestacao;
    private Long empenho;
    private Long exercicioEmpenho;
    private LocalDate dataEmpenho;
    private BigDecimal valorEmpenho;
    private BigDecimal valorPago;
    private BigDecimal valorDocumentos;
    private BigDecimal valorRestituido;
    private BigDecimal valorExcedido;
    private String cargo;
    private String lotacao;
    private String matricula;
    private String unidadeOrcamentaria;
    private Long noLiquidacao;
    private String displayEmpenho;
    private String permiteExcederPrestacaoContas;
    private Long empenhoExcedido;
    private Long exercicioEmpenhoExcedido;

    public AdiantamentoPessoalDTO(DiariaMovimentacaoDTO dto) {
        EmpenhoDTO empenho = Optional.ofNullable(dto.getEmpenho()).orElse(new EmpenhoDTO());
        ExercicioDTO exercicio = Optional.ofNullable(dto.getExercicio()).orElse(new ExercicioDTO());
        DotacaoDTO dotacao = Optional.ofNullable(dto.getDotacao()).orElse(new DotacaoDTO());
        CentralPagamentoDTO pagamento = Optional.ofNullable(dto.getPagamento()).orElse(new CentralPagamentoDTO());
        PessoaDTO servidor = Optional.ofNullable(dto.getServidor()).orElse(new PessoaDTO());
        List documentos = Optional.ofNullable(dto.getDocumentos()).orElse(new ArrayList());
        this.entidade = exercicio.getEntidade().getId();
        this.exercicio = exercicio.getExercicio();
        this.exercicioEmpenho = Optional.ofNullable(empenho.getExercicio()).map(ExercicioDTO::getExercicio).orElse(null);
        this.empenho = empenho.getNumeroEmpenho();
        this.dataEmpenho = empenho.getData();
        this.noLiquidacao = Optional.ofNullable(dto.getLiquidacao()).map(LiquidacaoDTO::getNumeroLiquidacao).orElse(0L);
        this.unidadeOrcamentaria = Optional.ofNullable(dotacao.getUnidade()).map(UnidadeDTO::getUnidadeOrgaoValue).orElse("");
        this.nome = servidor.getNome();
        this.cargo = servidor.getCargo();
        this.matricula = servidor.getMatricula();
        this.lotacao = dto.getLotacao();
        this.valorEmpenho = empenho.getValor();
        this.valorPago = pagamento.getValorLiquido();
        this.valorDocumentos = documentos.stream().map(DiariaMovimentacaoDocumentoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.valorRestituido = AdiantamentoPessoalDTO.resolveValorRestituido((BigDecimal)this.valorDocumentos, (BigDecimal)dto.getValorAdiantamento());
        this.prestacaoContas = dto.getNumeroSolicitacao();
        this.dataPrestacao = dto.getDataPrestacaoContas();
    }

    private static BigDecimal resolveValorRestituido(BigDecimal valorDocumentos, BigDecimal valorAdiantamento) {
        if (!BigDecimal.ZERO.equals(valorDocumentos)) {
            return valorAdiantamento.subtract(valorDocumentos);
        }
        return BigDecimal.ZERO;
    }

    public Long getEmpenhoExcedido() {
        return this.empenhoExcedido;
    }

    public void setEmpenhoExcedido(Long empenhoExcedido) {
        this.empenhoExcedido = empenhoExcedido;
    }

    public Long getExercicioEmpenhoExcedido() {
        return this.exercicioEmpenhoExcedido;
    }

    public void setExercicioEmpenhoExcedido(Long exercicioEmpenhoExcedido) {
        this.exercicioEmpenhoExcedido = exercicioEmpenhoExcedido;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public Long getPrestacaoContas() {
        return this.prestacaoContas;
    }

    public void setPrestacaoContas(Long prestacaoContas) {
        this.prestacaoContas = prestacaoContas;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public LocalDate getDataPrestacao() {
        return this.dataPrestacao;
    }

    public void setDataPrestacao(LocalDate dataPrestacao) {
        this.dataPrestacao = dataPrestacao;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public Long getExercicioEmpenho() {
        return this.exercicioEmpenho;
    }

    public void setExercicioEmpenho(Long exercicioEmpenho) {
        this.exercicioEmpenho = exercicioEmpenho;
    }

    public LocalDate getDataEmpenho() {
        return this.dataEmpenho;
    }

    public void setDataEmpenho(LocalDate dataEmpenho) {
        this.dataEmpenho = dataEmpenho;
    }

    public BigDecimal getValorEmpenho() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorEmpenho);
    }

    public void setValorEmpenho(BigDecimal valorEmpenho) {
        this.valorEmpenho = valorEmpenho;
    }

    public BigDecimal getValorPago() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorPago);
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    public BigDecimal getValorDocumentos() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorDocumentos);
    }

    public void setValorDocumentos(BigDecimal valorDocumentos) {
        this.valorDocumentos = valorDocumentos;
    }

    public BigDecimal getValorRestituido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorRestituido);
    }

    public BigDecimal getValorExcedido() {
        return NumberUtils.formatBigDecimal((BigDecimal)this.valorExcedido);
    }

    public void setValorRestituido(BigDecimal valorRestituido) {
        this.valorRestituido = valorRestituido;
    }

    public void setValorExcedido(BigDecimal valorExcedido) {
        this.valorExcedido = valorExcedido;
    }

    public String getCargo() {
        return this.cargo;
    }

    public void setCargo(String cargo) {
        this.cargo = cargo;
    }

    public String getLotacao() {
        return this.lotacao;
    }

    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    public String getMatricula() {
        return this.matricula;
    }

    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    public String getUnidadeOrcamentaria() {
        return this.unidadeOrcamentaria;
    }

    public void setUnidadeOrcamentaria(String unidadeOrcamentaria) {
        this.unidadeOrcamentaria = unidadeOrcamentaria;
    }

    public Long getNoLiquidacao() {
        return this.noLiquidacao;
    }

    public void setNoLiquidacao(Long noLiquidacao) {
        this.noLiquidacao = noLiquidacao;
    }

    public String getPermiteExcederPrestacaoContas() {
        return this.permiteExcederPrestacaoContas;
    }

    public void setPermiteExcederPrestacaoContas(String permiteExcederPrestacaoContas) {
        this.permiteExcederPrestacaoContas = permiteExcederPrestacaoContas;
    }

    public String getDisplayEmpenho() {
        return this.displayEmpenho;
    }

    public void setDisplayEmpenho(String displayEmpenho) {
        this.displayEmpenho = displayEmpenho;
    }

    @Generated
    public AdiantamentoPessoalDTO(Long entidade, Long exercicio, Long prestacaoContas, String nome, LocalDate dataPrestacao, Long empenho, Long exercicioEmpenho, LocalDate dataEmpenho, BigDecimal valorEmpenho, BigDecimal valorPago, BigDecimal valorDocumentos, BigDecimal valorRestituido, BigDecimal valorExcedido, String cargo, String lotacao, String matricula, String unidadeOrcamentaria, Long noLiquidacao, String displayEmpenho, String permiteExcederPrestacaoContas, Long empenhoExcedido, Long exercicioEmpenhoExcedido) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.prestacaoContas = prestacaoContas;
        this.nome = nome;
        this.dataPrestacao = dataPrestacao;
        this.empenho = empenho;
        this.exercicioEmpenho = exercicioEmpenho;
        this.dataEmpenho = dataEmpenho;
        this.valorEmpenho = valorEmpenho;
        this.valorPago = valorPago;
        this.valorDocumentos = valorDocumentos;
        this.valorRestituido = valorRestituido;
        this.valorExcedido = valorExcedido;
        this.cargo = cargo;
        this.lotacao = lotacao;
        this.matricula = matricula;
        this.unidadeOrcamentaria = unidadeOrcamentaria;
        this.noLiquidacao = noLiquidacao;
        this.displayEmpenho = displayEmpenho;
        this.permiteExcederPrestacaoContas = permiteExcederPrestacaoContas;
        this.empenhoExcedido = empenhoExcedido;
        this.exercicioEmpenhoExcedido = exercicioEmpenhoExcedido;
    }

    @Generated
    public AdiantamentoPessoalDTO() {
    }
}

