SELECT RECEITA_FONTETCE.RECEITA,
							FONTERECURSO.FONTERECURSO,
       SUM(CASE WHEN RD.GRUPOEVENTO in (11,14) then RDI.VALOR else RDI.VALOR*-1 END) VALORARRECADADO,
       RD.DATA
		FROM RECEITA R
		JOIN RECEITA_FONTETCE RECEITA_FONTETCE                             
			ON  RECEITA_FONTETCE.ENTIDADE    	        = R.ENTIDADE     
			AND RECEITA_FONTETCE.EXERCICIO             = R.EXERCICIO     
			AND RECEITA_FONTETCE.RECEITA               = R.RECEITA       
			AND RECEITA_FONTETCE.FONTERECURSO          = R.FONTERECURSO  
			AND RECEITA_FONTETCE.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
		JOIN FONTERECURSO FONTERECURSO                                       
		ON FONTERECURSO.FONTERECURSO = RECEITA_FONTETCE.VINCULOFONTERECURSO 
       JOIN REALIZACAORECEITA RD
         ON RD.ENTIDADE = R.ENTIDADE                               
		AND RD.EXERCICIO       = R.EXERCICIO                                        
		AND RD.RECEITA         = R.RECEITA                                        
		AND RD.FONTERECURSO = R.FONTERECURSO
		AND RD.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
		AND RD.DATA <= :numeroDias
       JOIN  REALIZACAORECEITAITEM RDI                                                     
		ON  RDI.ENTIDADE     = RD.ENTIDADE                                                
		AND  RDI.EXERCICIO    = RD.EXERCICIO                                               
		AND  RDI.LANCAMENTO   = RD.LANCAMENTO     
        AND  RDI.FONTERECURSO  = FONTERECURSO.FONTERECURSO
        AND  RDI.IDTIPOOPERACAORECEITA = RD.IDTIPOOPERACAORECEITA
		WHERE R.EXERCICIO           = :exercicio
		 AND COALESCE(R.MOVSN,'N') = 'S'
         AND R.ENTIDADE = :entidade
         AND R.RECEITA = :receita
         $[FILTRO]
		 $[FILTROFONTERECURSO]
		AND EXISTS (SELECT RD.ENTIDADE 
						FROM REALIZACAORECEITA RD 
						WHERE RD.ENTIDADE = R.ENTIDADE
						AND RD.EXERCICIO = R.EXERCICIO
						AND RD.RECEITA = R.RECEITA
						AND RD.FONTERECURSO = R.FONTERECURSO
						AND RD.IDTIPOOPERACAORECEITA = R.IDTIPOOPERACAORECEITA
						AND RD.DATA <= :numeroDias)
GROUP BY RECEITA_FONTETCE.RECEITA,
						  	FONTERECURSO.FONTERECURSO, RD.DATA
		ORDER BY RD.DATA