SELECT TB1.DATA, 
       SUM(TB1.VALOR) as VALOR, 
       TB1.TIPO 
  FROM (SELECT DATA AS DATA, 
               VALOR, 
               TIPO  
          FROM (SELECT T.DATA, 
                       T.VALOR VALOR, 
                       1 AS TIPO
                  FROM TRANSFERENCIAS T                            
                 WHERE T.ENTIDADE     = :entidade                  
                   AND T.LOCALDEBITO  = :local                     
                   AND T.LOCALCREDITO <> T.LOCALDEBITO             
                   AND T.SITUACAO     = 'C'                                                                                
                 UNION ALL                                       
                SELECT L.DATA, 
                       L.VALOR VALOR, 
                       1 AS TIPO                 
                  FROM LANCAMENTOSCONTABEIS L                    
                 WHERE L.ENTIDADE               = :entidade    
                   AND L.idContaCorrenteDEBITO  = :idContaCorrente
                   AND L.TIPOTRANSFERENCIA      IS NULL            
                   AND L.SEQUENCIATRANSFERENCIA IS NOT NULL        
                   AND L.GRUPOEVENTO <> '61'                    
                   AND NOT EXISTS (SELECT L2.ID                   
                                     FROM LANCAMENTOSCONTABEIS L2  
                                    WHERE L2.ENTIDADE           = L.ENTIDADE  
                                      AND L2.EXERCICIO          = L.EXERCICIO 
                                      AND L2.IDLANCAMENTOORIGEM = L.ID)) REPASSES                                                                          
         UNION ALL
        SELECT DATA, 
               VALOR, 
               TIPO  
          FROM (SELECT T.DATA, 
                       T.VALOR VALOR, 
                       2 AS TIPO                        
                  FROM TRANSFERENCIAS T                                  
                 WHERE T.ENTIDADE     = :entidade                        
                   AND T.LOCALCREDITO = :local                           
                   AND T.LOCALCREDITO <> T.LOCALDEBITO                   
                   AND T.SITUACAO     = 'N'                                                                                   
                 UNION ALL                                                
                SELECT L.DATA, 
                       L.VALOR VALOR, 
                       2 AS TIPO                         
                  FROM LANCAMENTOSCONTABEIS L                             
                 WHERE ENTIDADE               = :entidade                
                   AND idContaCorrenteCREDITO = :idContaCorrente          
                   AND TIPOTRANSFERENCIA      IS NULL                     
                   AND SEQUENCIATRANSFERENCIA IS NOT NULL                 
                   AND EXISTS (SELECT L2.ID                               
                                 FROM LANCAMENTOSCONTABEIS L2             
                                WHERE L2.ENTIDADE           = L.ENTIDADE  
                                  AND L2.EXERCICIO          = L.EXERCICIO 
                                  AND L2.IDLANCAMENTOORIGEM = L.ID)) DEVOLUCOES                                                                                        
         UNION ALL
        SELECT DATA, 
               VALOR, 
               TIPO  
          FROM (SELECT OP.DATA, 
                       OPL.VALOR AS VALOR, 
                       3 AS TIPO             
                  FROM ORDEMPAGAMENTO_LIQUIDACAO OPL 
                  LEFT OUTER JOIN PAGAMENTO OP ON OPL.ENTIDADE  = OP.ENTIDADE                  
                                              AND OPL.EXERCICIO = OP.ANOORDEMPAGAMENTO         
                                              AND OPL.NOORDEM   = OP.NOORDEMPAGAMENTO          
                  LEFT OUTER JOIN EMPENHO E ON OPL.ENTIDADE         = E.ENTIDADE            
                                           AND OPL.ANODOCORIGEM     = E.EXERCICIO           
                                           AND OPL.NODOCORIGEM      = E.EMPENHO             
                                           AND OPL.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA 
                 WHERE E.ENTIDADE      = :entidade                 
                   AND E.CONTRAPARTIDA = 'S'                     
                   AND OP.ESTORNO      = 'N'                      
                   AND E.ANOCONVENIO   = :nrAnoConvenio               
                   AND E.NOCONVENIO    = :nrConvenio                                            
                 UNION ALL 
                SELECT RL.DATACONTABILIZADO AS DATA, 
                       RL.VALOR AS VALOR, 
                       3 AS TIPO 
                  FROM ORDEMPAGAMENTO_LIQUIDACAO OPL                        
                  LEFT OUTER JOIN PAGAMENTO OP ON OPL.ENTIDADE  = OP.ENTIDADE                          
                                              AND OPL.EXERCICIO = OP.ANOORDEMPAGAMENTO                 
                                              AND OPL.NOORDEM   = OP.NOORDEMPAGAMENTO                  
                  LEFT OUTER JOIN EMPENHO E ON OPL.ENTIDADE         = E.ENTIDADE                    
                                           AND OPL.ANODOCORIGEM     = E.EXERCICIO                   
                                           AND OPL.NODOCORIGEM      = E.EMPENHO                     
                                           AND OPL.UNIDADEDOCORIGEM = E.UNIDADEORCAMENTARIA         
                  JOIN RETENCOESLIQUIDACAO RL ON RL.ENTIDADE         = OPL.ENTIDADE                   
                                             AND RL.EXERCICIO        = OPL.EXERCICIOLIQ               
                                             AND RL.TIPODOCORIGEM    = OPL.TIPODOCORIGEM              
                                             AND RL.ANODOCORIGEM     = OPL.ANODOCORIGEM               
                                             AND RL.NODOCORIGEM      = OPL.NODOCORIGEM                
                                             AND RL.UNIDADEDOCORIGEM = OPL.UNIDADEDOCORIGEM           
                                             AND RL.NOLIQUIDACAO     = OPL.NOLIQUIDACAO               
                 WHERE E.ENTIDADE      = :entidade                         
                   AND E.CONTRAPARTIDA = 'S'                             
                   AND OP.ESTORNO      = 'N'                            
                   AND E.ANOCONVENIO   = :nrAnoConvenio                    
                   AND E.NOCONVENIO    = :nrConvenio) PAGAMENTOS
) TB1  
 WHERE COALESCE(TB1.VALOR,0) > 0
   AND TB1.TIPO = :tipo 
 GROUP BY TB1.DATA, TB1.TIPO
 ORDER BY TB1.DATA


