/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain;

import br.com.elotech.core.common.dto.RegistroDTO;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.portaltransparencia.contabportal.domain.RegistroPK;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;

@Entity(name="Registro")
@Table
public class Registro
implements EloEntity<RegistroPK> {
    @EmbeddedId
    private RegistroPK id;
    @Column(name="DATALIBERACAO")
    private LocalDate dataLiberacao;
    private Long entidade;
    @Column(name="QTDENTIDADES")
    private Long qtdEntidades;
    private String codigo;
    private String senha;
    @Column(length=400)
    private String hash;

    public String getCalculatedHash() {
        return RegistroDTO.getCalculatedHash((LocalDate)this.getId().getValidade(), (String)this.getId().getModulo(), (String)this.getId().getNome(), (String)this.codigo);
    }

    public RegistroDTO toRegistroDTO() {
        RegistroDTO registroDTO = new RegistroDTO();
        registroDTO.setNome(this.registroIdNome());
        registroDTO.setModulo(this.registroIdModulo());
        registroDTO.setValidade(this.registroIdValidade());
        registroDTO.setCodigo(this.getCodigo());
        registroDTO.setDataLiberacao(this.getDataLiberacao());
        registroDTO.setEntidade(this.getEntidade());
        registroDTO.setHash(this.getHash());
        registroDTO.setQtdEntidades(this.getQtdEntidades());
        registroDTO.setSenha(this.getSenha());
        return registroDTO;
    }

    private String registroIdNome() {
        return this.registroID().getNome();
    }

    private String registroIdModulo() {
        return this.registroID().getModulo();
    }

    private LocalDate registroIdValidade() {
        return this.registroID().getValidade();
    }

    private RegistroPK registroID() {
        return this.getId();
    }

    @Generated
    public String toString() {
        return "Registro(id=" + this.getId() + ", dataLiberacao=" + this.getDataLiberacao() + ", entidade=" + this.getEntidade() + ", qtdEntidades=" + this.getQtdEntidades() + ", codigo=" + this.getCodigo() + ", senha=" + this.getSenha() + ", hash=" + this.getHash() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registro)) {
            return false;
        }
        Registro other = (Registro)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        RegistroPK this$id = this.getId();
        RegistroPK other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LocalDate this$dataLiberacao = this.getDataLiberacao();
        LocalDate other$dataLiberacao = other.getDataLiberacao();
        if (this$dataLiberacao == null ? other$dataLiberacao != null : !((Object)this$dataLiberacao).equals(other$dataLiberacao)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$qtdEntidades = this.getQtdEntidades();
        Long other$qtdEntidades = other.getQtdEntidades();
        if (this$qtdEntidades == null ? other$qtdEntidades != null : !((Object)this$qtdEntidades).equals(other$qtdEntidades)) {
            return false;
        }
        String this$codigo = this.getCodigo();
        String other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !this$codigo.equals(other$codigo)) {
            return false;
        }
        String this$senha = this.getSenha();
        String other$senha = other.getSenha();
        if (this$senha == null ? other$senha != null : !this$senha.equals(other$senha)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Registro;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegistroPK $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LocalDate $dataLiberacao = this.getDataLiberacao();
        result = result * 59 + ($dataLiberacao == null ? 43 : ((Object)$dataLiberacao).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $qtdEntidades = this.getQtdEntidades();
        result = result * 59 + ($qtdEntidades == null ? 43 : ((Object)$qtdEntidades).hashCode());
        String $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : $codigo.hashCode());
        String $senha = this.getSenha();
        result = result * 59 + ($senha == null ? 43 : $senha.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }

    @Generated
    public Registro() {
    }

    @Generated
    public RegistroPK getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataLiberacao() {
        return this.dataLiberacao;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getQtdEntidades() {
        return this.qtdEntidades;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getSenha() {
        return this.senha;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public void setId(RegistroPK id) {
        this.id = id;
    }

    @Generated
    public void setDataLiberacao(LocalDate dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setQtdEntidades(Long qtdEntidades) {
        this.qtdEntidades = qtdEntidades;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }
}

