/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.LicitacaoParticipanteDTO;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.ParticipanteLicitacoesDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.LicitacaoParticipanteRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.LicitacoesParticipanteParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LicitacaoParticipanteRepositoryImpl
implements LicitacaoParticipanteRepository {
    private static final String PARTICIPANTES = "db/sql/compras/participantes.sql";
    private static final String LICITACOES = "db/sql/compras/participanteLicitacoes.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public LicitacaoParticipanteRepositoryImpl(@Qualifier(value="wrapperCompras") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public Page<LicitacaoParticipanteDTO> findParticipantes(LicitacoesParticipanteParams params, Pageable pageable) {
        StringBuilder query = new StringBuilder(FileUtils.readResourceAsString((String)PARTICIPANTES));
        params.getNumeroLicitacao().ifPresent(numero -> query.append(" AND CL.NUMEROLICITACAO = :numeroLicitacao "));
        params.getPessoa().ifPresent(pessoa -> query.append(" AND P.PESSOA = :pessoa "));
        params.getCnpj().ifPresent(numero -> query.append(" AND P.CNPJ_CPF = :cnpj "));
        params.getNomeFantasia().ifPresent(p -> query.append(" AND tiraacento(UPPER(P.NOMEFANTASIA)) like tiraacento('%").append(((String)params.getNomeFantasia().get()).toUpperCase(LocaleContextHolder.getLocale()).replaceAll(" ", "%")).append("%') "));
        params.getRazaoSocial().ifPresent(p -> query.append(" AND tiraacento(UPPER(P.NOME)) like tiraacento('%").append(((String)params.getRazaoSocial().get()).toUpperCase(LocaleContextHolder.getLocale()).replaceAll(" ", "%")).append("%') "));
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)query.toString(), (String)"ORDER BY P.NOME");
        String sql = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List participantes = this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoParticipanteDTO.class));
        Long total = (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(this.getSqlCount(queryOrder), (SqlParameterSource)params.toJdbcParameter(), Long.class);
        return new PageImpl(participantes, pageable, total.longValue());
    }

    public LicitacaoParticipanteDTO findParticipante(LicitacoesParticipanteParams params) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)PARTICIPANTES));
        params.getPessoa().ifPresent(pessoa -> sql.append(" AND P.PESSOA = :pessoa "));
        return (LicitacaoParticipanteDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(LicitacaoParticipanteDTO.class));
    }

    public List<ParticipanteLicitacoesDTO> findLicitacoesParticipante(LicitacoesParticipanteParams params) {
        String sql = FileUtils.readResourceAsString((String)LICITACOES);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ParticipanteLicitacoesDTO.class));
    }

    private String getSqlCount(String sql) {
        return "SELECT COUNT(1) TOTAL FROM (" + sql + ") T";
    }
}

