/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.adm.compras.client.ObrasClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.oxy.adm.compras.client.portal.ObrasPortalDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.ObraAcompanhamentoImagem;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.MedicaoObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.PlanilhaObraDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.ObraRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindObraParams;
import br.com.elotech.portaltransparencia.aiseportal.service.EntidadeAiseService;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ObraOxyRepositoryImpl
implements ObraRepository {
    private ObrasClient obrasClient;
    private EntidadeAiseService entidadeAiseService;

    public ObraOxyRepositoryImpl(ObrasClient obrasClient, EntidadeAiseService entidadeAiseService) {
        this.obrasClient = obrasClient;
        this.entidadeAiseService = entidadeAiseService;
    }

    public Page<ObraDTO> findObras(FindObraParams params, Pageable pageable) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        EloPage oxyDtoPage = this.obrasClient.findObras(params.toObrasOxyParams(), pageable);
        List obrasList = oxyDtoPage.getContent().stream().map(ObraDTO::fromOxy).collect(Collectors.toList());
        ObraDTO.setFieldsDisplay(obrasList);
        return new PageImpl(obrasList, pageable, oxyDtoPage.getTotalElements());
    }

    public ObraDTO findObra(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return ObraDTO.fromOxy((ObrasPortalDTO)this.obrasClient.findObra(params.toObrasOxyParams()));
    }

    public List<MedicaoObraDTO> findMedicoes(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return this.obrasClient.findMedicoes(params.toObrasOxyParams()).stream().map(MedicaoObraDTO::fromOxy).collect(Collectors.toList());
    }

    public List<PlanilhaObraDTO> findPlanilhas(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return this.obrasClient.findPlanilhas(params.toObrasOxyParams()).stream().map(PlanilhaObraDTO::fromOxy).collect(Collectors.toList());
    }

    public List<ObraAcompanhamentoImagem> findImagensMedicao(FindObraParams params) {
        this.entidadeAiseService.setCodigoEntidadeAise((AiseParams)params);
        return this.obrasClient.findImagensMedicao(params.toObrasOxyParams()).stream().map(ObraAcompanhamentoImagem::fromOxy).collect(Collectors.toList());
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao() {
        return this.obrasClient.findUltimaAtualizacao().stream().map(UltimaAtualizacaoDTO::fromUltimaAtualizacaoOxy).collect(Collectors.toList());
    }
}

