/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import br.com.elotech.almoxarifado.dto.portal.ItemEstoquePortalParamsDTO;
import br.com.elotech.portaltransparencia.web.rest.params.ItemEstoqueParams;
import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemEstoqueParams {
    public static final String DEFAULT_STRING = "TODOS";
    public static final Long DEFAULT_NUMBER = -99L;
    private Long entidade;
    private Long centroCusto;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate data;
    private String orgao;
    private String itemDescricao;
    private String exportType;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addData(params);
        this.addOrgao(params);
        this.addCentroCusto(params);
        this.addItemDescricao(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (!Objects.isNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addData(MapSqlParameterSource params) {
        if (Objects.nonNull(this.data)) {
            params.addValue("data", (Object)Date.valueOf(this.data), 91);
        }
    }

    private void addOrgao(MapSqlParameterSource params) {
        this.orgao = Optional.ofNullable(this.orgao).orElse("TODOS");
        params.addValue("orgao", (Object)this.orgao.trim().toUpperCase(Locale.getDefault()), 12);
    }

    private void addCentroCusto(MapSqlParameterSource params) {
        this.centroCusto = Optional.ofNullable(this.centroCusto).orElse(DEFAULT_NUMBER);
        params.addValue("centroCusto", (Object)this.centroCusto, 2);
    }

    private void addItemDescricao(MapSqlParameterSource params) {
        this.itemDescricao = Optional.ofNullable(this.itemDescricao).orElse("TODOS");
        params.addValue("itemDescricao", (Object)("%" + this.itemDescricao.trim().toUpperCase(Locale.getDefault()) + "%"), 12);
    }

    public ItemEstoquePortalParamsDTO toOxyAdmEntity() {
        ItemEstoquePortalParamsDTO itemEstoquePortalParamsDTO = new ItemEstoquePortalParamsDTO();
        itemEstoquePortalParamsDTO.setEntidade(this.getEntidade());
        itemEstoquePortalParamsDTO.setCentroCusto(this.getCentroCusto());
        itemEstoquePortalParamsDTO.setOrgao(this.getOrgao());
        itemEstoquePortalParamsDTO.setItemDescricao(this.getItemDescricao());
        itemEstoquePortalParamsDTO.setExportType(this.getExportType());
        if (this.getData() != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            itemEstoquePortalParamsDTO.setData(formatter.format(this.getData()));
        }
        return itemEstoquePortalParamsDTO;
    }

    @Generated
    private static LocalDate $default$data() {
        return LocalDate.now();
    }

    @Generated
    public static ItemEstoqueParamsBuilder builder() {
        return new ItemEstoqueParamsBuilder();
    }

    @Generated
    public String toString() {
        return "ItemEstoqueParams(entidade=" + this.getEntidade() + ", centroCusto=" + this.getCentroCusto() + ", data=" + this.getData() + ", orgao=" + this.getOrgao() + ", itemDescricao=" + this.getItemDescricao() + ", exportType=" + this.getExportType() + ")";
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getCentroCusto() {
        return this.centroCusto;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getOrgao() {
        return this.orgao;
    }

    @Generated
    public String getItemDescricao() {
        return this.itemDescricao;
    }

    @Generated
    public String getExportType() {
        return this.exportType;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setCentroCusto(Long centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setOrgao(String orgao) {
        this.orgao = orgao;
    }

    @Generated
    public void setItemDescricao(String itemDescricao) {
        this.itemDescricao = itemDescricao;
    }

    @Generated
    public void setExportType(String exportType) {
        this.exportType = exportType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemEstoqueParams)) {
            return false;
        }
        ItemEstoqueParams other = (ItemEstoqueParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$centroCusto = this.getCentroCusto();
        Long other$centroCusto = other.getCentroCusto();
        if (this$centroCusto == null ? other$centroCusto != null : !((Object)this$centroCusto).equals(other$centroCusto)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$orgao = this.getOrgao();
        String other$orgao = other.getOrgao();
        if (this$orgao == null ? other$orgao != null : !this$orgao.equals(other$orgao)) {
            return false;
        }
        String this$itemDescricao = this.getItemDescricao();
        String other$itemDescricao = other.getItemDescricao();
        if (this$itemDescricao == null ? other$itemDescricao != null : !this$itemDescricao.equals(other$itemDescricao)) {
            return false;
        }
        String this$exportType = this.getExportType();
        String other$exportType = other.getExportType();
        return !(this$exportType == null ? other$exportType != null : !this$exportType.equals(other$exportType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ItemEstoqueParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $centroCusto = this.getCentroCusto();
        result = result * 59 + ($centroCusto == null ? 43 : ((Object)$centroCusto).hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $orgao = this.getOrgao();
        result = result * 59 + ($orgao == null ? 43 : $orgao.hashCode());
        String $itemDescricao = this.getItemDescricao();
        result = result * 59 + ($itemDescricao == null ? 43 : $itemDescricao.hashCode());
        String $exportType = this.getExportType();
        result = result * 59 + ($exportType == null ? 43 : $exportType.hashCode());
        return result;
    }

    @Generated
    public ItemEstoqueParams() {
        this.data = ItemEstoqueParams.$default$data();
    }

    @Generated
    public ItemEstoqueParams(Long entidade, Long centroCusto, LocalDate data, String orgao, String itemDescricao, String exportType) {
        this.entidade = entidade;
        this.centroCusto = centroCusto;
        this.data = data;
        this.orgao = orgao;
        this.itemDescricao = itemDescricao;
        this.exportType = exportType;
    }

    static /* synthetic */ LocalDate access$000() {
        return ItemEstoqueParams.$default$data();
    }
}

