/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.atos.client.AtosFeignClient;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.AditivoConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ArquivoPessoalDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RepasseConvenioDTO;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindConvenioParams;
import br.com.elotech.portaltransparencia.contabportal.service.ConvenioService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConvenioOxyService
implements ConvenioService {
    private static final String NR_CONVENIO = "nrConvenio";
    private static final String NR_ANO_CONVENIO = "nrAnoConvenio";
    private static final String SITUACAO = "situacao";
    private static final String DESTINATARIO = "destinario";
    private static final HashMap<String, Function<Sort.Direction, Sort.Order>> ORDERS = new HashMap();
    private static final HashMap<String, Function<String, String>> FILTERS = new HashMap();
    private final AtosFeignClient atosFeignClient;

    public Optional<ConvenioDTO> findConvenio(FindConvenioParams params) {
        return Optional.ofNullable(this.atosFeignClient.findConvenioById(params.getId())).map(ConvenioDTO::new);
    }

    public Page<ConvenioDTO> findConvenios(FindConvenioParams params, Pageable pageable) {
        EloPage convenios = this.atosFeignClient.findAllConvenios(ConvenioOxyService.buildSearch((FindConvenioParams)params), this.buildSort(pageable));
        return new PageImpl(convenios.getContent().stream().map(ConvenioDTO::new).collect(Collectors.toList()), pageable, convenios.getTotalElements());
    }

    public List<AditivoConvenioDTO> findAditivos(FindConvenioParams params) {
        ArrayList<AditivoConvenioDTO> aditivos = new ArrayList<AditivoConvenioDTO>();
        Optional.of(this.atosFeignClient.findConvenioById(params.getId())).ifPresent(convenio -> aditivos.addAll(convenio.getAditivos().stream().map(AditivoConvenioDTO::new).collect(Collectors.toList())));
        return aditivos;
    }

    public List<ArquivoPessoalDTO> findArquivos(FindConvenioParams params) {
        return new ArrayList<ArquivoPessoalDTO>();
    }

    public List<RepasseConvenioDTO> findRepassesConvenio(FindConvenioParams params) {
        return new ArrayList<RepasseConvenioDTO>();
    }

    public List<RepasseConvenioDTO> findContraPartida(FindConvenioParams params) {
        return new ArrayList<RepasseConvenioDTO>();
    }

    public List<RepasseConvenioDTO> findPagamentosConvenio(FindConvenioParams params) {
        return new ArrayList<RepasseConvenioDTO>();
    }

    private static String buildSearch(FindConvenioParams params) {
        StringBuilder search = new StringBuilder();
        params.getNrConvenio().ifPresent(nrConvenio -> search.append((String)((Function)FILTERS.get("nrConvenio")).apply(nrConvenio.toString())));
        params.getNrAnoConvenio().ifPresent(anoConvenio -> search.append((String)((Function)FILTERS.get("nrAnoConvenio")).apply(anoConvenio.toString())));
        params.getSituacao().ifPresent(situacao -> search.append((String)((Function)FILTERS.get("situacao")).apply(situacao.toString())));
        params.getDestinatario().ifPresent(destinatario -> search.append((String)((Function)FILTERS.get("destinario")).apply(destinatario)));
        if (search.toString().isEmpty()) {
            return "";
        }
        return search.substring(1);
    }

    private Pageable buildSort(Pageable pageable) {
        ArrayList orders = new ArrayList();
        if (pageable.getSort().isSorted()) {
            pageable.getSort().toList().forEach(sort -> orders.add(((Function)ORDERS.get(sort.getProperty())).apply(sort.getDirection())));
        }
        return PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)Sort.by(orders));
    }

    @Generated
    public ConvenioOxyService(AtosFeignClient atosFeignClient) {
        this.atosFeignClient = atosFeignClient;
    }

    static {
        ORDERS.put("nrConvenio", direction -> new Sort.Order(direction, "numero"));
        ORDERS.put("nrAnoConvenio", direction -> new Sort.Order(direction, "ano"));
        ORDERS.put("nome", direction -> new Sort.Order(direction, "beneficiario.pessoa.nome"));
        ORDERS.put("valorConvenio", direction -> new Sort.Order(direction, "valor"));
        ORDERS.put("cnpj", direction -> new Sort.Order(direction, "beneficiario.pessoa.cnpjCpf"));
        ORDERS.put("situacao", direction -> new Sort.Order(direction, "situacaoConvenio"));
        ORDERS.put("dataInicioVigencia", direction -> new Sort.Order(direction, "dataInicioVigencia"));
        ORDERS.put("dataFimVigencia", direction -> new Sort.Order(direction, "dataFimVigencia"));
        ORDERS.put("fonteRecurso", direction -> new Sort.Order(direction, "fonteRecurso.codigo"));
        FILTERS.put("nrConvenio", filter -> ";numero==" + filter);
        FILTERS.put("nrAnoConvenio", filter -> ";ano==" + filter);
        FILTERS.put("situacao", filter -> ";situacaoConvenio==" + filter);
        FILTERS.put("destinario", filter -> ";beneficiario.pessoa.nome=='*" + filter + "*'");
    }
}

