/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AdjudicacaoLicitacaoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AdjudicacaoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAdjudicacaoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindLicitacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AdjudicacaoRepositoryImpl
implements AdjudicacaoRepository {
    private static final String ADJUDICACAO = "db/sql/compras/adjudicacao.sql";
    private static final String ADJUDICACOES = "db/sql/compras/adjudicacoes.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AdjudicacaoRepositoryImpl(@Qualifier(value="wrapperCompras") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public AdjudicacaoLicitacaoDTO findAdjudicacao(FindAdjudicacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ADJUDICACAO).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        return (AdjudicacaoLicitacaoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AdjudicacaoLicitacaoDTO.class));
    }

    public List<AdjudicacaoLicitacaoDTO> findAdjudicacoes(FindLicitacaoParams params, String nomeSchemaEloArquivo) {
        String sql = FileUtils.readResourceAsString((String)ADJUDICACOES).replace("schema_eloarquivo", nomeSchemaEloArquivo);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AdjudicacaoLicitacaoDTO.class));
    }
}

