/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource.params;

import br.com.elotech.portaltransparencia.aiseportal.resource.params.AfastamentoParams;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.AiseParams;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class AfastamentoParams
implements AiseParams {
    private String nome;
    private Long entidade;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataInicial;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataFinal;
    private Long tipoAfastamento;
    private Boolean afastamentoVigente;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate dataAtual;

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addNome(params);
        this.addDataInicial(params);
        this.addDataFinal(params);
        this.addTipoAfastamento(params);
        this.addDataAtual(params);
        return params;
    }

    private void addTipoAfastamento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.tipoAfastamento)) {
            params.addValue("tipoAfastamento", (Object)this.tipoAfastamento);
        }
    }

    private void addDataInicial(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataInicial)) {
            params.addValue("dataInicial", (Object)this.dataInicial);
        }
    }

    private void addDataFinal(MapSqlParameterSource params) {
        if (Objects.nonNull(this.dataFinal)) {
            params.addValue("dataFinal", (Object)this.dataFinal);
        }
    }

    private void addNome(MapSqlParameterSource params) {
        if (Objects.nonNull(this.nome)) {
            params.addValue("nome", (Object)this.nome);
        }
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade);
        }
    }

    private void addDataAtual(MapSqlParameterSource params) {
        params.addValue("dataAtual", (Object)LocalDate.now().toString(), 91);
    }

    public void setEntidadeAise(Long entidadeAise) {
        this.setEntidade(entidadeAise);
    }

    public Long getEntidadeAise() {
        return this.entidade;
    }

    @Generated
    public static AfastamentoParamsBuilder builder() {
        return new AfastamentoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "AfastamentoParams(nome=" + this.getNome() + ", entidade=" + this.getEntidade() + ", dataInicial=" + this.getDataInicial() + ", dataFinal=" + this.getDataFinal() + ", tipoAfastamento=" + this.getTipoAfastamento() + ", afastamentoVigente=" + this.getAfastamentoVigente() + ", dataAtual=" + this.getDataAtual() + ")";
    }

    @Generated
    public AfastamentoParams() {
    }

    @Generated
    public AfastamentoParams(String nome, Long entidade, LocalDate dataInicial, LocalDate dataFinal, Long tipoAfastamento, Boolean afastamentoVigente, LocalDate dataAtual) {
        this.nome = nome;
        this.entidade = entidade;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.tipoAfastamento = tipoAfastamento;
        this.afastamentoVigente = afastamentoVigente;
        this.dataAtual = dataAtual;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    @Generated
    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    @Generated
    public Long getTipoAfastamento() {
        return this.tipoAfastamento;
    }

    @Generated
    public Boolean getAfastamentoVigente() {
        return this.afastamentoVigente;
    }

    @Generated
    public LocalDate getDataAtual() {
        return this.dataAtual;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Generated
    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Generated
    public void setTipoAfastamento(Long tipoAfastamento) {
        this.tipoAfastamento = tipoAfastamento;
    }

    @Generated
    public void setAfastamentoVigente(Boolean afastamentoVigente) {
        this.afastamentoVigente = afastamentoVigente;
    }

    @Generated
    public void setDataAtual(LocalDate dataAtual) {
        this.dataAtual = dataAtual;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AfastamentoParams)) {
            return false;
        }
        AfastamentoParams other = (AfastamentoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        LocalDate this$dataInicial = this.getDataInicial();
        LocalDate other$dataInicial = other.getDataInicial();
        if (this$dataInicial == null ? other$dataInicial != null : !((Object)this$dataInicial).equals(other$dataInicial)) {
            return false;
        }
        LocalDate this$dataFinal = this.getDataFinal();
        LocalDate other$dataFinal = other.getDataFinal();
        if (this$dataFinal == null ? other$dataFinal != null : !((Object)this$dataFinal).equals(other$dataFinal)) {
            return false;
        }
        Long this$tipoAfastamento = this.getTipoAfastamento();
        Long other$tipoAfastamento = other.getTipoAfastamento();
        if (this$tipoAfastamento == null ? other$tipoAfastamento != null : !((Object)this$tipoAfastamento).equals(other$tipoAfastamento)) {
            return false;
        }
        Boolean this$afastamentoVigente = this.getAfastamentoVigente();
        Boolean other$afastamentoVigente = other.getAfastamentoVigente();
        if (this$afastamentoVigente == null ? other$afastamentoVigente != null : !((Object)this$afastamentoVigente).equals(other$afastamentoVigente)) {
            return false;
        }
        LocalDate this$dataAtual = this.getDataAtual();
        LocalDate other$dataAtual = other.getDataAtual();
        return !(this$dataAtual == null ? other$dataAtual != null : !((Object)this$dataAtual).equals(other$dataAtual));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AfastamentoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        LocalDate $dataInicial = this.getDataInicial();
        result = result * 59 + ($dataInicial == null ? 43 : ((Object)$dataInicial).hashCode());
        LocalDate $dataFinal = this.getDataFinal();
        result = result * 59 + ($dataFinal == null ? 43 : ((Object)$dataFinal).hashCode());
        Long $tipoAfastamento = this.getTipoAfastamento();
        result = result * 59 + ($tipoAfastamento == null ? 43 : ((Object)$tipoAfastamento).hashCode());
        Boolean $afastamentoVigente = this.getAfastamentoVigente();
        result = result * 59 + ($afastamentoVigente == null ? 43 : ((Object)$afastamentoVigente).hashCode());
        LocalDate $dataAtual = this.getDataAtual();
        result = result * 59 + ($dataAtual == null ? 43 : ((Object)$dataAtual).hashCode());
        return result;
    }
}

