/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaContribuinteDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaDTO;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import br.com.elotech.portaltransparencia.aiseportal.service.DividaAtivaService;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/dividas-ativas"})
public class DividaAtivaResource {
    private final DividaAtivaService service;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public DividaAtivaResource(DividaAtivaService service, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<Page<DividaAtivaDTO>> findDividasAtivas(FindDividaAtivaParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findDividasAtivas(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findDividasAtivasExport(HttpServletRequest request, HttpServletResponse response, FindDividaAtivaParams params, Pageable pageable) throws Throwable {
        PageRequest pageRequest = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        Page dividasAtivasPage = this.service.findDividasAtivas(params, (Pageable)pageRequest);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidadeContabil());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Divida Ativa");
        reportParam.setClazzDTO(DividaAtivaDTO.class);
        if (params.getShowValor().booleanValue()) {
            reportParam.setHeaderFields("Nome,CPF/CNPJ,Valor");
            reportParam.setFields("nome,cnpjCpfDB,valor");
            float[] fieldsPerc = new float[]{5.0f, 3.0f, 2.0f};
            reportParam.setWidthsFieldsPerc(fieldsPerc);
            int[] fieldTab = new int[]{100, 20, 20};
            reportParam.setWidthsFieldsTab(fieldTab);
        } else {
            reportParam.setHeaderFields("Nome,CPF/CNPJ");
            reportParam.setFields("nome,cnpjCpfDB");
            float[] fieldsPerc = new float[]{6.0f, 4.0f};
            reportParam.setWidthsFieldsPerc(fieldsPerc);
            int[] fieldTab = new int[]{100, 20};
            reportParam.setWidthsFieldsTab(fieldTab);
        }
        reportParam.setPage(dividasAtivasPage);
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/contribuinte"}, params={"nome", "cnpjCpfDB"})
    public ResponseEntity<List<DividaAtivaContribuinteDTO>> findDividasAtivasContribuinte(FindDividaAtivaParams params) {
        return ResponseEntity.ok((Object)this.service.findDividasAtivasContribuinte(params));
    }

    @GetMapping(value={"/total"})
    public ResponseEntity<DividaAtivaContribuinteDTO> findValorTotalDividasAtivas(FindDividaAtivaParams params) {
        return ResponseEntity.ok((Object)this.service.findValorTotalDividasAtivas(params));
    }
}

