SELECT R.LANCAMENTO, 
       R.DATA, 
       UPPER(TE.DESCRICAO) AS DESCRICAO, 
       R.BANCO, 
       R.AGENCIA, 
       R.CONTA, 
       R.CONTRIBUINTE, 
       R.CNPJ, 
       R.VALOR 
  FROM REALIZACAORECEITA R 
  LEFT JOIN EXERCICIO EX 
    ON R.ENTIDADE = EX.ENTIDADE 
   AND R.EXERCICIO = EX.EXERCICIO 
  LEFT JOIN TABELAEVENTO TE 
    ON R.ENTIDADE = TE.ENTIDADE 
   AND R.EXERCICIO = TE.EXERCICIO 
   AND TE.MODELO = EX.MODELOPLANO 
   AND R.TIPOEVENTO = TE.TIPOEVENTO 
   AND R.GRUPOEVENTO = TE.GRUPOEVENTO 
   AND R.EVENTO = TE.EVENTO 
 WHERE R.ENTIDADE = :entidade
   AND R.EXERCICIO = :exercicio
   AND R.RECEITA = :receita
   AND R.DATA = :data
       $[FILTRO]