/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.web.rest.params;

import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class ProgramaticaParams {
    public static final Long ORG = 1L;
    public static final Long UNI = 2L;
    public static final Long FUN = 3L;
    public static final Long SFU = 4L;
    public static final Long PRO = 5L;
    public static final Long PRJ = 6L;
    public static final Long ELE = 10L;
    public static final Long DES = 11L;
    public static final Long SDE = 12L;
    private Long entidade;
    private Long exercicio;
    private String orgao;
    private String unidade;
    private String funcao;
    private String subFuncao;
    private String programa;
    private String projeto;
    private String elemento;
    private String desdobramento;
    private String subDesdobramento;

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public String getOrgao() {
        return this.orgao;
    }

    public void setOrgao(String orgao) {
        this.orgao = orgao;
    }

    public String getUnidade() {
        if (Objects.nonNull(this.unidade)) {
            return this.orgao.concat(this.unidade);
        }
        return null;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    public String getFuncao() {
        return this.funcao;
    }

    public void setFuncao(String funcao) {
        this.funcao = funcao;
    }

    public String getSubFuncao() {
        return this.subFuncao;
    }

    public void setSubFuncao(String subFuncao) {
        this.subFuncao = subFuncao;
    }

    public String getPrograma() {
        return this.programa;
    }

    public void setPrograma(String programa) {
        this.programa = programa;
    }

    public String getProjeto() {
        return this.projeto;
    }

    public void setProjeto(String projeto) {
        this.projeto = projeto;
    }

    public String getElemento() {
        if (this.elemento != null) {
            return this.elemento.concat("%");
        }
        return null;
    }

    public void setElemento(String elemento) {
        this.elemento = elemento;
    }

    public String getDesdobramento() {
        return this.desdobramento;
    }

    public void setDesdobramento(String desdobramento) {
        this.desdobramento = desdobramento;
    }

    public String getSubDesdobramento() {
        return this.subDesdobramento;
    }

    public void setSubDesdobramento(String subDesdobramento) {
        this.subDesdobramento = subDesdobramento;
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.addEntidade(params);
        this.addExercicio(params);
        this.addOrgao(params);
        this.addUnidade(params);
        this.addFuncao(params);
        this.addSubFuncao(params);
        this.addPrograma(params);
        this.addProjeto(params);
        this.addElemento(params);
        this.addDesdobramento(params);
        this.addSubDesdobramento(params);
        return params;
    }

    private void addEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void addExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void addOrgao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.orgao)) {
            params.addValue("orgao", (Object)this.orgao, 12);
        }
    }

    private void addUnidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.unidade)) {
            params.addValue("unidade", (Object)this.orgao.concat(this.unidade), 12);
        }
    }

    private void addFuncao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.funcao)) {
            params.addValue("funcao", (Object)this.funcao, 12);
        }
    }

    private void addSubFuncao(MapSqlParameterSource params) {
        if (Objects.nonNull(this.subFuncao)) {
            params.addValue("subFuncao", (Object)this.subFuncao, 12);
        }
    }

    private void addPrograma(MapSqlParameterSource params) {
        if (Objects.nonNull(this.programa)) {
            params.addValue("programa", (Object)this.programa, 12);
        }
    }

    private void addProjeto(MapSqlParameterSource params) {
        if (Objects.nonNull(this.projeto)) {
            params.addValue("projeto", (Object)this.projeto, 12);
        }
    }

    private void addElemento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.elemento)) {
            params.addValue("elemento", (Object)this.elemento, 12);
        }
    }

    private void addDesdobramento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.desdobramento)) {
            params.addValue("desdobramento", (Object)this.desdobramento, 12);
        }
    }

    private void addSubDesdobramento(MapSqlParameterSource params) {
        if (Objects.nonNull(this.subDesdobramento)) {
            params.addValue("subDesdobramento", (Object)this.subDesdobramento, 12);
        }
    }

    public String montaFiltro(Long nivel) {
        StringBuilder where = new StringBuilder();
        this.filterOrgao(nivel, where);
        this.fitlerUnidade(nivel, where);
        this.filterFuncao(nivel, where);
        this.filterSubFuncao(nivel, where);
        this.filterPrograma(nivel, where);
        this.filterProjeto(nivel, where);
        this.filterElemento(nivel, where);
        this.filterDesdobramento(nivel, where);
        this.filterSubDesdobramento(nivel, where);
        where.append("\n ORDER BY CODIGO");
        return where.toString();
    }

    private void filterOrgao(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.orgao) && nivel > ORG) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,ORG.POSICAO,ORG.TAMANHO) = :orgao");
        }
    }

    private void fitlerUnidade(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.unidade) && nivel > UNI) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,UNID.POSICAO,UNID.TAMANHO) = :unidade");
        }
    }

    private void filterFuncao(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.funcao) && nivel > FUN) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,FUNCAO.POSICAO,FUNCAO.TAMANHO) = :funcao");
        }
    }

    private void filterSubFuncao(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.subFuncao) && nivel > SFU) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,SUBFUNCAO.POSICAO,SUBFUNCAO.TAMANHO) = :subFuncao");
        }
    }

    private void filterPrograma(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.programa) && nivel > PRO) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,PROG.POSICAO,PROG.TAMANHO) = :programa");
        }
    }

    private void filterProjeto(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.projeto) && nivel > PRJ) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,PROJ.POSICAO,PROJ.TAMANHO) = :projeto");
        }
    }

    private void filterElemento(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.elemento) && nivel > ELE) {
            where.append("\n AND SUBSTR(DESP.PROGRAMATICA,ELEM.POSICAO,ELEM.TAMANHO-4) LIKE :elemento");
        }
    }

    private void filterDesdobramento(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.desdobramento) && nivel > DES) {
            where.append("\n AND E.DESDOBRADESP = :desdobramento");
        }
    }

    private void filterSubDesdobramento(Long nivel, StringBuilder where) {
        if (Objects.nonNull(this.subDesdobramento) && nivel > SDE) {
            where.append("\n AND E.SUBDESDOBRAMENTO = :subDesdobramento");
        }
    }

    @Generated
    public ProgramaticaParams() {
    }

    @Generated
    public ProgramaticaParams(Long entidade, Long exercicio, String orgao, String unidade, String funcao, String subFuncao, String programa, String projeto, String elemento, String desdobramento, String subDesdobramento) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.orgao = orgao;
        this.unidade = unidade;
        this.funcao = funcao;
        this.subFuncao = subFuncao;
        this.programa = programa;
        this.projeto = projeto;
        this.elemento = elemento;
        this.desdobramento = desdobramento;
        this.subDesdobramento = subDesdobramento;
    }

    @Generated
    public String toString() {
        return "ProgramaticaParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", orgao=" + this.getOrgao() + ", unidade=" + this.getUnidade() + ", funcao=" + this.getFuncao() + ", subFuncao=" + this.getSubFuncao() + ", programa=" + this.getPrograma() + ", projeto=" + this.getProjeto() + ", elemento=" + this.getElemento() + ", desdobramento=" + this.getDesdobramento() + ", subDesdobramento=" + this.getSubDesdobramento() + ")";
    }
}

