/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.LeisAtosNaturezaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.LeisAtosParams;
import br.com.elotech.portaltransparencia.contabportal.service.LeisAtosService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/leisatos"})
public class LeisAtosResource {
    private final LeisAtosService leisAtosService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    @Autowired
    public LeisAtosResource(LeisAtosService leisAtosService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
        this.leisAtosService = leisAtosService;
    }

    @GetMapping(params={"entidade", "exercicio"})
    public ResponseEntity<Page<LeisAtosDTO>> findLeisAtos(@Valid LeisAtosParams params, Pageable pageable) {
        return ResponseEntity.ok((Object)this.leisAtosService.findLeisAtos(params, pageable));
    }

    @GetMapping(value={"/detalhes"})
    public ResponseEntity<LeisAtosDTO> findOneLeiAto(@Valid LeisAtosParams params) {
        return ResponseEntity.ok((Object)this.leisAtosService.findOneLeiAto(params));
    }

    @GetMapping(value={"/naturezas"})
    public ResponseEntity<List<LeisAtosNaturezaDTO>> findTiposContrato(@Valid LeisAtosParams params) {
        return ResponseEntity.ok((Object)this.leisAtosService.findLeisAtosNatureza(params));
    }

    @GetMapping(value={"/tipos-documento-legal"})
    public ResponseEntity<List<LeisAtosNaturezaDTO>> findTiposDocumentoLegal(@Valid LeisAtosParams params) {
        return ResponseEntity.ok((Object)this.leisAtosService.findTiposDocumentoLegal(params));
    }

    @GetMapping(value={"/escopo"})
    public ResponseEntity<List<LeisAtosNaturezaDTO>> findTiposEscopo(@Valid LeisAtosParams params) {
        return ResponseEntity.ok((Object)this.leisAtosService.findTiposEscopo(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findLeisAtosExport(HttpServletRequest request, HttpServletResponse response, @Valid LeisAtosParams params, Pageable pageable) throws Throwable {
        params.setExercicio(params.getExercicio());
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.leisAtosService.findLeisAtos(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Leis e Atos");
        reportParam.setClazzDTO(LeisAtosDTO.class);
        reportParam.setHeaderFields("Natureza,N\u00famero,Ano,Descri\u00e7\u00e3o,Data,Ve\u00edculo Publica\u00e7\u00e3o,S\u00famula,Tipo Documento Legal");
        reportParam.setFields("natureza,numero,exercicio,descricao,data,veiculoPublicacao,sumula,tipoDocumentoLegal");
        float[] fieldsPerc = new float[]{1.0f, 0.7f, 0.5f, 2.0f, 0.7f, 1.0f, 2.8f, 1.3f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{30, 10, 10, 500, 15, 50, 1000, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

