/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.EntidadeBrasaoDTO;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/entidades", "/admin/api/entidades"})
public class EntidadeResource {
    private final EntidadeContabilidadeService entidadeService;

    @Autowired
    public EntidadeResource(EntidadeContabilidadeService entidadeService) {
        this.entidadeService = entidadeService;
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Entidade> findEntidade(@PathVariable(value="id") Long id) {
        Entidade entidade = this.entidadeService.findOne(id);
        if (Objects.isNull(entidade)) {
            return ResponseEntity.notFound().build();
        }
        entidade.setRegistrado(this.entidadeService.verificaRegistro(entidade).booleanValue());
        entidade.setHabilitadoPortal(this.entidadeService.isHabilitadoPortal(id));
        return ResponseEntity.ok((Object)entidade);
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<List<Entidade>> findListEntidades() {
        return ResponseEntity.ok((Object)this.entidadeService.getEntidades());
    }

    @GetMapping(value={"/{id}/brasao"})
    public ResponseEntity<EntidadeBrasaoDTO> findBrasaoEntidade(@PathVariable(value="id") Long id) {
        Entidade entidade = this.entidadeService.findOne(id);
        if (Objects.isNull(entidade)) {
            return ResponseEntity.notFound().build();
        }
        if (Objects.isNull(entidade.getBrasao())) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)new EntidadeBrasaoDTO(entidade.getBrasao()));
    }

    @GetMapping
    public ResponseEntity<List<Entidade>> findAll() {
        return ResponseEntity.ok((Object)this.entidadeService.findAll());
    }
}

