/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.utils.StringUtils;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ComprasDiretaFornecedorDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.ComprasDiretaService;
import br.com.elotech.portaltransparencia.contabportal.service.EmpenhoService;
import br.com.elotech.portaltransparencia.web.rest.params.ComprasDiretaParams;
import br.com.elotech.portaltransparencia.web.rest.params.EmpenhoParams;
import java.time.LocalDate;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/compras-direta"})
public class ComprasDiretaResource {
    private final ComprasDiretaService comprasDiretaService;
    private final EmpenhoService empenhoService;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;
    private final ElotechProperties elotechProperties;

    @Autowired
    public ComprasDiretaResource(ComprasDiretaService comprasDiretaService, EmpenhoService empenhoService, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository, ElotechProperties elotechProperties) {
        this.comprasDiretaService = comprasDiretaService;
        this.empenhoService = empenhoService;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping(value={"/fornecedor"})
    public ResponseEntity<Page<ComprasDiretaFornecedorDTO>> getComprasDiretasPorFornecedor(Pageable pageable, ComprasDiretaParams params) {
        return ResponseEntity.ok((Object)this.comprasDiretaService.getFornecedores(pageable, params));
    }

    @GetMapping(value={"/fornecedor/report"})
    public ModelAndView getCompraDiretaExport(Pageable pageable, HttpServletRequest request, HttpServletResponse response, ComprasDiretaParams params) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        Page list = this.comprasDiretaService.getFornecedores((Pageable)page, params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Compras Direta por Fornecedores");
        reportParam.setClazzDTO(ComprasDiretaFornecedorDTO.class);
        reportParam.setHeaderFields("Nome,CNPJ/CPF,Empenhado,Anulado,Liquidado,Retido,Pago,A Pagar");
        reportParam.setFields("nome,cnpjCpf,empenhado,anulado,liquidado,retido,pago,aPagar");
        float[] fieldsPerc = new float[]{2.1f, 1.3f, 1.2f, 1.0f, 1.1f, 1.1f, 1.1f, 1.1f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{100, 20, 20, 20, 20, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setSumFields("empenhado,anulado,liquidado,retido,pago,aPagar");
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(value={"/fornecedor/totais"})
    public ComprasDiretaFornecedorDTO getFornecedoresTotais(ComprasDiretaParams params) {
        return this.comprasDiretaService.getFornecedoresTotais(params);
    }

    @GetMapping(value={"/itens"})
    public ResponseEntity<Page<ComprasDiretaDTO>> getComprasDiretasPorItens(Pageable pageable, @RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, EmpenhoParams params) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        if (params.getComprasDireta().booleanValue()) {
            this.montaFiltroPorMes(params);
        }
        return ResponseEntity.ok((Object)this.empenhoService.getComprasDiretaItensEmpenho(pageable, params));
    }

    @GetMapping(value={"/itens/report"})
    public ModelAndView getCompraDiretaExport(Pageable pageable, HttpServletRequest request, HttpServletResponse response, EmpenhoParams params) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros());
        Page list = this.empenhoService.getComprasDiretaItensEmpenho((Pageable)page, params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Compras Direta por Itens");
        reportParam.setClazzDTO(ComprasDiretaDTO.class);
        reportParam.setHeaderFields("Empenho,Exercicio,Data,Processo,Cnpj,Fornecedor,Item,Qtde,Valor Unit\u00e1rio, Valor Total");
        reportParam.setFields("empenho,exercicio,data,numeroProcesso,cnpj,fornecedor,item,quantidade,valorUnitario,valorTotal");
        float[] fieldsPerc = new float[]{0.5f, 0.5f, 1.0f, 0.5f, 1.0f, 2.0f, 2.0f, 0.5f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{15, 15, 15, 15, 15, 50, 50, 15, 15, 15};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    private void montaFiltroPorMes(EmpenhoParams params) {
        int fimMes;
        StringBuilder filtro = new StringBuilder();
        if (Objects.nonNull(params.getMesInicialMov())) {
            filtro.append(String.format(" and fichasEmpenho.id.data>='%s-%s-01'", params.getExercicio(), StringUtils.getStringNumeroMes((Long)params.getMesInicialMov())));
        }
        if (Objects.nonNull(params.getMesFinalMov())) {
            fimMes = LocalDate.of(params.getExercicio().intValue(), params.getMesFinalMov().intValue(), 1).lengthOfMonth();
            filtro.append(String.format(" and fichasEmpenho.id.data<='%s-%s-%s'", params.getExercicio(), StringUtils.getStringNumeroMes((Long)params.getMesFinalMov()), fimMes));
        }
        if (Objects.nonNull(params.getMesInicialEmissao()) && Objects.nonNull(params.getMesFinalEmissao())) {
            fimMes = LocalDate.of(params.getExercicio().intValue(), params.getMesFinalEmissao().intValue(), 1).lengthOfMonth();
            filtro.append(String.format(" and data>='%s-%s-01' and data<='%s-%s-%s'", params.getExercicio(), StringUtils.getStringNumeroMes((Long)params.getMesInicialEmissao()), params.getExercicio(), StringUtils.getStringNumeroMes((Long)params.getMesFinalEmissao()), fimMes));
        }
        params.setSearch(params.getSearch() + filtro.toString());
    }
}

