/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.config;

import java.util.HashMap;
import java.util.Optional;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(entityManagerFactoryRef="entityManagerAise", transactionManagerRef="transactionManagerAise", basePackages={"br.com.elotech.portaltransparencia.aiseportal"})
public class DataSourceConfigAise {
    public static final String DIALECT = "${db.aise.dialect:}";
    private static final String PREFIX = "spring.datasource.aise";
    private static final String[] DOMAINPACKAGES = new String[]{"br.com.elotech.portaltransparencia.aiseportal.domain"};

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.aise")
    public DataSource dataSourceAise() {
        return DataSourceBuilder.create().build();
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerAise(EntityManagerFactoryBuilder builder, @Qualifier(value="dataSourceAise") DataSource dataSourceAise, @Value(value="${db.aise.dialect:}") String dialect, Optional<HibernatePropertiesCustomizer> propertiesCustomizer) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", dialect);
        propertiesCustomizer.ifPresent(props -> props.customize(properties));
        return builder.dataSource(dataSourceAise).packages(DOMAINPACKAGES).persistenceUnit("aiseportal").properties(properties).build();
    }

    @Bean
    public PlatformTransactionManager transactionManagerAise(@Qualifier(value="entityManagerAise") LocalContainerEntityManagerFactoryBean entityManager) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManager.getObject());
        return transactionManager;
    }
}

