/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.service.impl;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.portaltransparencia.admportal.domain.Parametros;
import br.com.elotech.portaltransparencia.admportal.service.PortalParametroService;
import br.com.elotech.portaltransparencia.aiseportal.cache.DividaContribuinteCacheHandler;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaContribuinteDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.DividaAtivaDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.DividaAtivaRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.FindDividaAtivaParams;
import br.com.elotech.portaltransparencia.aiseportal.service.DividaAtivaService;
import br.com.elotech.portaltransparencia.aiseportal.service.impl.DividaAtivaSmtServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DividaAtivaServiceImpl
implements DividaAtivaService {
    private static final String FONTE_DADOS_AISE = "1";
    private final DividaAtivaRepository repository;
    private final PortalParametroService portalParametroService;
    private final DividaAtivaSmtServiceImpl dividaAtivaSmtService;
    private DividaContribuinteCacheHandler dividaContribuinteCacheHandler;

    public DividaAtivaServiceImpl(DividaAtivaRepository repository, PortalParametroService portalParametroService, DividaAtivaSmtServiceImpl dividaAtivaSmtService) {
        this.repository = repository;
        this.portalParametroService = portalParametroService;
        this.dividaAtivaSmtService = dividaAtivaSmtService;
    }

    public Page<DividaAtivaDTO> findDividasAtivas(FindDividaAtivaParams params, Pageable pageable) {
        params.setSomenteAjuizado(SimNao.toBoolean((String)this.getSomenteAjuizado(), (Boolean)false));
        if (this.isFonteDadosAise().booleanValue()) {
            return this.repository.findDividasAtivas(params, pageable);
        }
        return this.dividaAtivaSmtService.findDividasAtivas(params, pageable);
    }

    public List<DividaAtivaContribuinteDTO> findDividasAtivasContribuinte(FindDividaAtivaParams params) {
        if (this.isFonteDadosAise().booleanValue()) {
            return this.repository.findDividasAtivasContribuinte(params);
        }
        return this.dividaAtivaSmtService.findDividasAtivasContribuinte(params);
    }

    @VisibleForTesting
    protected Boolean isFonteDadosAise() {
        String parametroFonteDados = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_DIVIDAATIVA_FONTE_DE_DADOS);
        return Strings.nullToEmpty((String)parametroFonteDados).equals(FONTE_DADOS_AISE);
    }

    @VisibleForTesting
    protected String getSomenteAjuizado() {
        String parametroSomenteAjuizado = this.portalParametroService.getPortalParametroValor(Parametros.NAO_DEPENDE_ENTIDADE, Parametros.NAO_DEPENDE_EXERCICIO, Parametros.PARAM_DIVIDA_ATIVA_SOMENTE_AJUIZADO);
        return Strings.nullToEmpty((String)parametroSomenteAjuizado);
    }

    public DividaAtivaContribuinteDTO findValorTotalDividasAtivas(FindDividaAtivaParams params) {
        if (this.isFonteDadosAise().booleanValue()) {
            Optional total;
            if (this.dividaContribuinteCacheHandler == null) {
                this.dividaContribuinteCacheHandler = new DividaContribuinteCacheHandler(arg_0 -> ((DividaAtivaRepository)this.repository).findValorTotalDividasAtivas(arg_0));
            }
            if ((total = (Optional)this.dividaContribuinteCacheHandler.getCache().get((Object)params)).isPresent()) {
                return (DividaAtivaContribuinteDTO)total.get();
            }
        }
        return new DividaAtivaContribuinteDTO();
    }
}

