SELECT DISTINCT CL.ENTIDADE, 
       CL.EXERCICIO, 
       PD.PESSOA,
       T.DESCRICAO MODALIDADE, 
       CL.LICITACAO, 
       CL.DATAABERTURA,
       CC.NUMEROCONTRATO,
       ARQ.IDARQUIVO, 
       CASE WHEN ARQ.NOMEARQUIVO IS NULL THEN ELOARQ.NOME ELSE ARQ.NOMEARQUIVO END AS NOMEARQUIVO
  FROM CLFORNECEDORDOCUMENTACAO PD
  JOIN CLLICITACAO CL
    ON CL.ENTIDADE = PD.ENTIDADE
   AND CL.EXERCICIO = PD.EXERCICIO
   AND CL.LICITACAO = PD.LICITACAO
  LEFT JOIN CLCONTRATO CC
    ON CC.PESSOA = PD.PESSOA
   AND CC.EXERCICIO = PD.EXERCICIO
   AND CC.LICITACAO = CL.LICITACAO
   AND CC.TIPOLICITACAO = CL.TIPOLICITACAO
  LEFT JOIN CLTIPOLICITACAO T
    ON T.TIPOLICITACAO = CL.TIPOLICITACAO
  LEFT JOIN ARQUIVO ARQ 
    ON ARQ.ID = CC.IDARQUIVO
  LEFT JOIN eloarquivo.ARQUIVO ELOARQ 
    ON ELOARQ.ID = ARQ.IDARQUIVO 
  LEFT JOIN eloarquivo.ARQUIVO_CONTENT AC 
    ON AC.ID = ARQ.IDARQUIVO
 WHERE PD.ENTIDADE = :entidade
   AND PD.PESSOA = :pessoa