SELECT A.ENTIDADE,
       A.EXERCICIO,
       A.CONTRATO,
       A.NUMEROCONTRATO,
       B.NOME,
       A.INICIOVIGENCIA,
       A.TERMINOVIGENCIA,
       A.VALORCONTRATADO,
       A.VALORADITIVO,
       A.TIPOATO,
       C.UNIDADEFEDERACAO AS UF,
       A.TIPOCONTRATO,
       TIPOLIC.DESCRICAO AS DESCRICAOTIPOLICITACAO,
       L.NUMEROLICITACAO,
       A.OBJETO,
       A.ENTIDADELICITACAO,
       ENT_LIC.NOME AS DESCRICAOENTIDADELICITACAO,
       A.EXERCICIOLICITACAO,
  CASE A.TIPOATO
  WHEN 1 THEN 'Contrato'
  WHEN 2 THEN 'Registro de Preço' END AS DESCRICAOTIPOATO,
  CASE WHEN (SELECT COUNT(*)
               FROM CLCONTRATOATOCONTRATUAL B
              WHERE A.ENTIDADE = B.ENTIDADE
                AND A.EXERCICIO = B.EXERCICIOCONTRATO
                AND A.CONTRATO = B.CONTRATO
                AND B.IDTIPOADITIVO = 5
                AND B.IDTIPOOPERACAO = 10) >= 1
       THEN 'Rescindido'
       WHEN A.TERMINOVIGENCIA IS NOT NULL AND A.TERMINOVIGENCIA < :dataAtual
        AND (SELECT coalesce(max(b.datatermino), :dataZero) FROM CLCONTRATOATOCONTRATUAL B
              WHERE A.ENTIDADE = B.ENTIDADE
                AND A.EXERCICIO = B.EXERCICIOCONTRATO
                AND A.CONTRATO = B.CONTRATO
                AND B.DATATERMINO IS NOT NULL) < :dataAtual
       THEN 'Encerrado'
       ELSE 'Vigente' END AS CANCELADO,
       CASE WHEN ((SELECT DISTINCT AD.INICIORESCISAO
                     FROM CLCONTRATOATOCONTRATUAL AD
                    WHERE AD.ENTIDADE          = A.ENTIDADE
                      AND AD.EXERCICIOCONTRATO = A.EXERCICIO
                      AND AD.CONTRATO          = A.CONTRATO
                      AND AD.IDTIPOADITIVO IN (5)
                      AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                            FROM CLCONTRATOATOCONTRATUAL UAD
                                           WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                             AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                             AND UAD.CONTRATO          = AD.CONTRATO
                                             AND UAD.IDTIPOADITIVO IN (5))) IS null)
            THEN CASE WHEN((SELECT DISTINCT AD.DATATERMINO
                              FROM CLCONTRATOATOCONTRATUAL AD
      	                     WHERE AD.ENTIDADE          = A.ENTIDADE
                               AND AD.EXERCICIOCONTRATO = A.EXERCICIO
                               AND AD.CONTRATO          = A.CONTRATO
                               AND AD.IDTIPOADITIVO IN (1,7)
                               AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                                     FROM CLCONTRATOATOCONTRATUAL UAD
                                                    WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                                      AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                                      AND UAD.CONTRATO          = AD.CONTRATO
                                                      AND UAD.IDTIPOADITIVO IN (1,7) )) IS NULL)
                      THEN A.TERMINOVIGENCIA
                      ELSE (SELECT DISTINCT AD.DATATERMINO
                              FROM CLCONTRATOATOCONTRATUAL AD
      	                     WHERE AD.ENTIDADE          = A.ENTIDADE
                               AND AD.EXERCICIOCONTRATO = A.EXERCICIO
                               AND AD.CONTRATO          = A.CONTRATO
                               AND AD.IDTIPOADITIVO IN (1,7)
                               AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                                     FROM CLCONTRATOATOCONTRATUAL UAD
                                                    WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                                      AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                                      AND UAD.CONTRATO          = AD.CONTRATO
                                                      AND UAD.IDTIPOADITIVO IN (1,7) )) END
            ELSE (SELECT DISTINCT AD.INICIORESCISAO
                    FROM CLCONTRATOATOCONTRATUAL AD
      	           WHERE AD.ENTIDADE          = A.ENTIDADE
                     AND AD.EXERCICIOCONTRATO = A.EXERCICIO
      	             AND AD.CONTRATO          = A.CONTRATO
                     AND AD.IDTIPOADITIVO IN (5)
                     AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                           FROM CLCONTRATOATOCONTRATUAL UAD
                                          WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                            AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                            AND UAD.CONTRATO          = AD.CONTRATO
                                            AND UAD.IDTIPOADITIVO IN (5) )) end VIGENCIA,
  CAST (CASE WHEN ((SELECT DISTINCT AD.INICIORESCISAO
                      FROM CLCONTRATOATOCONTRATUAL AD
                     WHERE AD.ENTIDADE          = A.ENTIDADE
                       AND AD.EXERCICIOCONTRATO = A.EXERCICIO
                       AND AD.CONTRATO          = A.CONTRATO
                       AND AD.IDTIPOADITIVO IN (5)
                       AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                             FROM CLCONTRATOATOCONTRATUAL UAD
                                            WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                              AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                              AND UAD.CONTRATO          = AD.CONTRATO
                                              AND UAD.IDTIPOADITIVO IN (5))) IS null)
             THEN CASE WHEN((SELECT DISTINCT AD.DATATERMINO
                               FROM CLCONTRATOATOCONTRATUAL AD
                              WHERE AD.ENTIDADE          = A.ENTIDADE
                                AND AD.EXERCICIOCONTRATO = A.EXERCICIO
                                AND AD.CONTRATO          = A.CONTRATO
                                AND AD.IDTIPOADITIVO IN (1,7)
                                AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                                      FROM CLCONTRATOATOCONTRATUAL UAD
                                                     WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                                       AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                                       AND UAD.CONTRATO          = AD.CONTRATO
                                                       AND UAD.IDTIPOADITIVO IN (1,7) )) IS NULL)
                       THEN A.TERMINOVIGENCIA
                       ELSE (SELECT DISTINCT AD.DATATERMINO
                               FROM CLCONTRATOATOCONTRATUAL AD
      	                      WHERE AD.ENTIDADE          = A.ENTIDADE
                                AND AD.EXERCICIOCONTRATO = A.EXERCICIO
                                AND AD.CONTRATO          = A.CONTRATO
                                AND AD.IDTIPOADITIVO IN (1,7)
                                AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                                      FROM CLCONTRATOATOCONTRATUAL UAD
                                                     WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                                       AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                                       AND UAD.CONTRATO          = AD.CONTRATO
                                                       AND UAD.IDTIPOADITIVO IN (1,7) )) END
             ELSE (SELECT DISTINCT AD.INICIORESCISAO
                     FROM CLCONTRATOATOCONTRATUAL AD
      	            WHERE AD.ENTIDADE          = A.ENTIDADE
                      AND AD.EXERCICIOCONTRATO = A.EXERCICIO
      	              AND AD.CONTRATO          = A.CONTRATO
                      AND AD.IDTIPOADITIVO IN (5)
                      AND AD.SEQUENCIA = (SELECT MAX(UAD.SEQUENCIA)
                                            FROM CLCONTRATOATOCONTRATUAL UAD
                                           WHERE UAD.ENTIDADE          = AD.ENTIDADE
                                             AND UAD.EXERCICIOCONTRATO = AD.EXERCICIOCONTRATO
                                             AND UAD.CONTRATO          = AD.CONTRATO
                                             AND UAD.IDTIPOADITIVO IN (5) ) )
  END AS DATE) - CAST(CAST(CURRENT_DATE AS VARCHAR(10)) AS DATE) diasVencimento,
  A.RATEIO  
  FROM CLCONTRATO A
 LEFT JOIN CLLICITACAO L
    ON A.ENTIDADELICITACAO = L.ENTIDADE
   AND A.EXERCICIOLICITACAO = L.EXERCICIO
   AND A.TIPOLICITACAO = L.TIPOLICITACAO
   AND A.LICITACAO = L.LICITACAO
 LEFT JOIN CLTIPOLICITACAO TIPOLIC
    ON L.TIPOLICITACAO = TIPOLIC.TIPOLICITACAO
 INNER JOIN PESSOA B
    ON A.PESSOA = B.PESSOA
 INNER JOIN ENTIDADE C
    ON C.ENTIDADE = A.ENTIDADE
 LEFT JOIN ENTIDADE ENT_LIC
    ON ENT_LIC.ENTIDADE = L.ENTIDADE
  LEFT JOIN PARAMETRO P
    ON P.ENTIDADE = L.ENTIDADE
   AND P.EXERCICIO = L.EXERCICIO
   AND P.PARAMETRO = 259
