/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MovimentoGaragemDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.MovimentoGaragemParams;
import br.com.elotech.portaltransparencia.contabportal.service.MovimentoGaragemService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/movimento-garagem"})
public class MovimentoGaragemResource {
    private final MovimentoGaragemService movimentoGaragemService;
    private final BaseExport baseExport;
    private final ElotechProperties elotechProperties;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public MovimentoGaragemResource(MovimentoGaragemService movimentoGaragemService, BaseExport baseExport, ElotechProperties elotechProperties, EntidadeContabilidadeRepository entidadeRepository) {
        this.movimentoGaragemService = movimentoGaragemService;
        this.baseExport = baseExport;
        this.elotechProperties = elotechProperties;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping
    public ResponseEntity<Page<MovimentoGaragemDTO>> findMovimentosGaragem(@RequestHeader(value="entidade") Long entidade, @RequestHeader(value="exercicio") Long exercicio, @Valid MovimentoGaragemParams params, Pageable pageable) {
        params.setEntidade(entidade);
        params.setExercicio(exercicio);
        return ResponseEntity.ok((Object)this.movimentoGaragemService.findMovimentosGaragem(params, pageable));
    }

    @GetMapping(value={"/report"})
    public ModelAndView findMovimentoGaragemExport(HttpServletRequest request, HttpServletResponse response, @Valid MovimentoGaragemParams params, Pageable pageable) throws Throwable {
        PageRequest page = PageRequest.of((int)0, (int)this.elotechProperties.getReport().getMaximoRegistros(), (Sort)pageable.getSort());
        Page list = this.movimentoGaragemService.findMovimentosGaragem(params, (Pageable)page);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setReportTitle("Listagem da movimenta\u00e7\u00e3o dos ve\u00edculos do munic\u00edpio");
        reportParam.setClazzDTO(MovimentoGaragemDTO.class);
        reportParam.setHeaderFields("Ve\u00edculo,Descri\u00e7\u00e3o,Data Sa\u00edda,Hora Sa\u00edda,Data Retorno,Hora Retorno,Destino,Complemento Destino");
        reportParam.setFields("veiculoNumero,veiculoDescricao,dataSaida,horaSaida,dataRetorno,horaRetorno,destino,complementoDestino");
        float[] fieldsPerc = new float[]{2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{50, 50, 50, 50, 50, 50, 50, 50};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(list.getContent());
        reportParam.setFontSize(8.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }

    @GetMapping(params={"entidade", "exercicio", "numero"})
    public ResponseEntity<MovimentoGaragemDTO> findMovimentoGaragem(@Valid MovimentoGaragemParams params) {
        return this.movimentoGaragemService.findMovimentoGaragem(params).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"N\u00e3o foi poss\u00edvel encontrar este movimento garagem."));
    }
}

