/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.portaltransparencia.contabportal.domain.ArquivoContab;
import br.com.elotech.portaltransparencia.contabportal.service.ArquivoContabilService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/admin/arquivos"})
public class ArquivoResource {
    private final ArquivoContabilService arquivoService;

    public ArquivoResource(ArquivoContabilService arquivoService) {
        this.arquivoService = arquivoService;
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ArquivoContab> getArquivo(@PathVariable Long id) throws URISyntaxException {
        ArquivoContab arquivoContab = this.arquivoService.findOne(id);
        if (Objects.isNull(arquivoContab)) {
            throw RestException.notFound((String)"Arquivo n\u00e3o encontrado!");
        }
        return ResponseEntity.created((URI)new URI("")).body((Object)this.arquivoService.save(arquivoContab));
    }

    @PostMapping
    public ResponseEntity<ArquivoContab> saveArquivo(@RequestParam(value="file") MultipartFile file, @RequestParam(value="nome") String nome) throws URISyntaxException, IOException {
        if (file.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        ArquivoContab arquivoContab = this.arquivoService.salvarArquivo(file, nome);
        return ResponseEntity.created((URI)new URI("")).body((Object)this.arquivoService.save(arquivoContab));
    }
}

