/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.RealizacaoReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.ReceitaDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.ReceitaRepository;
import br.com.elotech.portaltransparencia.contabportal.repository.impl.EntidadeContabilidadeRepositoryImpl;
import br.com.elotech.portaltransparencia.contabportal.resource.params.FindReceitaParams;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ReceitaRepositoryImpl
implements ReceitaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceitaRepositoryImpl.class);
    private static final String FILTRO = "$[FILTRO]";
    private static final String RECEITAS = "db/sql/contab/receitas.sql";
    private static final String RECEITAS_DETALHADAS = "db/sql/contab/receitas-detalhadas.sql";
    private static final String RECEITAS_POR_FONTE_RECURSO = "db/sql/contab/receitasPorFonteRecurso.sql";
    private static final String DETALHE_RECEITAS_POR_FONTE_RECURSO = "db/sql/contab/detalheReceitasPorFonteRecurso.sql";
    private static final String RECEITA = "db/sql/contab/receita.sql";
    private static final String RECEITAS_DIA = "db/sql/contab/receitas-dia.sql";
    private static final String RECEITAS_RAZAO = "db/sql/contab/receitas-razao.sql";
    private static final String RECEITAS_GRAFICO_ANUAL = "db/sql/contab/receitas-grafico-anual.sql";
    private final DatasourceWrapper datasourceWrapper;
    private final EntidadeContabilidadeRepositoryImpl entidadeContabilidade;

    @Autowired
    public ReceitaRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper, EntidadeContabilidadeRepositoryImpl entidadeContabilidade) {
        this.datasourceWrapper = datasourceWrapper;
        this.entidadeContabilidade = entidadeContabilidade;
    }

    public List<ReceitaDTO> findReceitas(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<ReceitaDTO> findReceitasDetalhada(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_DETALHADAS);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<ReceitaDTO> findReceitasPorFonteRecurso(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_POR_FONTE_RECURSO);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<ReceitaDTO> findDetalheReceitasPorFonteRecurso(FindReceitaParams params) {
        String sql = FileUtils.readResourceAsString((String)DETALHE_RECEITAS_POR_FONTE_RECURSO);
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    private void consoleLogger(FindReceitaParams params, String sql) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
    }

    public List<ReceitaDTO> findReceitaValoresDia(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS_DIA));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }

    public List<RealizacaoReceitaDTO> findReceitaValoresRazao(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS_RAZAO));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(RealizacaoReceitaDTO.class));
    }

    public Optional<ReceitaDTO> findReceita(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITA));
        this.consoleLogger(params, sql);
        ElotechBeanPropertyRowMapper rowMapper = new ElotechBeanPropertyRowMapper(ReceitaDTO.class);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)rowMapper).stream().findFirst();
    }

    private String concatenarFiltros(FindReceitaParams params, String sqlOriginal) {
        StringBuilder filtro = new StringBuilder();
        params.getDataInicial().ifPresent(i -> filtro.append(" AND RD.DATA >= :dataInicial "));
        params.getDataFinal().ifPresent(i -> filtro.append(" AND RD.DATA <= :dataFinal "));
        params.getFonteRecurso().ifPresent(i -> filtro.append(" AND R.FONTERECURSO = :fonteRecurso "));
        return sqlOriginal.replace(FILTRO, filtro.toString());
    }

    public List<ReceitaDTO> findReceitaValorMes(FindReceitaParams params) {
        String sql = this.concatenarFiltros(params, FileUtils.readResourceAsString((String)RECEITAS_GRAFICO_ANUAL));
        this.consoleLogger(params, sql);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(this.entidadeContabilidade.getTamanhoReceita(params.getEntidade(), params.getExercicio()).intValue()), (RowMapper)new ElotechBeanPropertyRowMapper(ReceitaDTO.class));
    }
}

