/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.domain.dto;

import br.com.elotech.core.utils.NumberUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

public class EmpenhosListaDTO {
    private Long entidade;
    private Long empenho;
    private Long exercicio;
    private String empenhoExercicio;
    private LocalDate data;
    private Long fornecedor;
    private String nome;
    private String historico;
    private BigDecimal valorEmpenhado;
    private BigDecimal valorAnulado;
    private BigDecimal valorLiquidado;
    private BigDecimal valorRetido;
    private BigDecimal valorPago;
    private BigDecimal valorAPagar;
    @JsonIgnore
    private String programatica;
    @JsonIgnore
    private String desdobraDesp;
    @JsonIgnore
    private String subDesdobramento;

    public EmpenhosListaDTO() {
    }

    public EmpenhosListaDTO(BigDecimal valorEmpenhado, BigDecimal valorAnulado, BigDecimal valorLiquidado, BigDecimal valorRetido, BigDecimal valorPago, BigDecimal valorAPagar) {
        this.valorEmpenhado = valorEmpenhado;
        this.valorAnulado = valorAnulado;
        this.valorLiquidado = valorLiquidado;
        this.valorRetido = valorRetido;
        this.valorPago = valorPago;
        this.valorAPagar = valorAPagar;
    }

    public Long getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    public Long getEmpenho() {
        return this.empenho;
    }

    public void setEmpenho(Long empenho) {
        this.empenho = empenho;
    }

    public Long getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    public Long getFornecedor() {
        return this.fornecedor;
    }

    public void setFornecedor(Long fornecedor) {
        this.fornecedor = fornecedor;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public BigDecimal getValorEmpenhado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorEmpenhado);
    }

    public void setValorEmpenhado(BigDecimal valorEmpenhado) {
        this.valorEmpenhado = valorEmpenhado;
    }

    public BigDecimal getValorLiquidado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorLiquidado);
    }

    public void setValorLiquidado(BigDecimal valorLiquidado) {
        this.valorLiquidado = valorLiquidado;
    }

    public BigDecimal getValorPago() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorPago);
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    public BigDecimal getValorRetido() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorRetido);
    }

    public void setValorRetido(BigDecimal valorRetido) {
        this.valorRetido = valorRetido;
    }

    public BigDecimal getValorAPagar() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorAPagar);
    }

    public void setValorAPagar(BigDecimal valorAPagar) {
        this.valorAPagar = valorAPagar;
    }

    public BigDecimal getValorAnulado() {
        return NumberUtils.formatBigDecimalRound((BigDecimal)this.valorAnulado);
    }

    public void setValorAnulado(BigDecimal valorAnulado) {
        this.valorAnulado = valorAnulado;
    }

    public String getEmpenhoExercicio() {
        return this.empenhoExercicio;
    }

    public void setEmpenhoExercicio(String empenhoExercicio) {
        this.empenhoExercicio = empenhoExercicio;
    }

    public String getProgramatica() {
        return this.programatica;
    }

    public void setProgramatica(String programatica) {
        this.programatica = programatica;
    }

    public String getDesdobraDesp() {
        return this.desdobraDesp;
    }

    public void setDesdobraDesp(String desdobraDesp) {
        this.desdobraDesp = desdobraDesp;
    }

    public String getSubDesdobramento() {
        return this.subDesdobramento;
    }

    public void setSubDesdobramento(String subDesdobramento) {
        this.subDesdobramento = subDesdobramento;
    }

    public LocalDate getData() {
        return this.data;
    }

    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public String toString() {
        return "EmpenhosListaDTO(entidade=" + this.getEntidade() + ", empenho=" + this.getEmpenho() + ", exercicio=" + this.getExercicio() + ", empenhoExercicio=" + this.getEmpenhoExercicio() + ", data=" + this.getData() + ", fornecedor=" + this.getFornecedor() + ", nome=" + this.getNome() + ", historico=" + this.getHistorico() + ", valorEmpenhado=" + this.getValorEmpenhado() + ", valorAnulado=" + this.getValorAnulado() + ", valorLiquidado=" + this.getValorLiquidado() + ", valorRetido=" + this.getValorRetido() + ", valorPago=" + this.getValorPago() + ", valorAPagar=" + this.getValorAPagar() + ", programatica=" + this.getProgramatica() + ", desdobraDesp=" + this.getDesdobraDesp() + ", subDesdobramento=" + this.getSubDesdobramento() + ")";
    }
}

