/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AditivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AditivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAditivoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AditivoRepositoryImpl
implements AditivoRepository {
    private static final String ADITIVOS = "db/sql/compras/aditivos.sql";
    private static final String ADITIVO = "db/sql/compras/aditivo.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public AditivoRepositoryImpl(@Qualifier(value="wrapperCompras") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<AditivoDTO> findAditivos(FindContratoParams params) {
        String sql = FileUtils.readResourceAsString((String)ADITIVOS);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AditivoDTO.class));
    }

    public AditivoDTO findAditivo(FindAditivoParams params) {
        String sql = FileUtils.readResourceAsString((String)ADITIVO);
        String query = this.filtroFindOne(params, sql);
        return (AditivoDTO)this.datasourceWrapper.getJdbcTemplate().queryForObject(query, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(AditivoDTO.class));
    }

    private String filtroFindOne(FindAditivoParams params, String sql) {
        StringBuilder query = new StringBuilder(sql);
        params.getExercicio().ifPresent(p -> query.append(" AND A.EXERCICIO = :exercicio "));
        params.getNumero().ifPresent(p -> query.append(" AND A.NUMERO = :numero "));
        params.getSequencia().ifPresent(p -> query.append(" AND A.SEQUENCIA = :sequencia "));
        return query.toString();
    }
}

