/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.arquivoportal.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.portaltransparencia.arquivoportal.domain.ArquivoContent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="eloarquivo.arquivo")
@DynamicUpdate
@JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer"})
public class Arquivo
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="GEN_ELOARQUIVO", schema="eloarquivo")
    @Caption(value="C\u00f3digo")
    private Long id;
    @Column(length=2000)
    @Caption(value="Nome Arquivo")
    private String nome;
    @Caption(value="Data Cria\u00e7\u00e3o")
    private LocalDate dataCriacao;
    @Caption(value="Conte\u00fado")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true, mappedBy="arquivo")
    private ArquivoContent content = new ArquivoContent().withArquivo(this);

    public Arquivo() {
    }

    @JsonCreator
    public Arquivo(@JsonProperty(value="id") Long id, @JsonProperty(value="nome") String nome, @JsonProperty(value="dataCriacao") LocalDate dataCriacao, @JsonProperty(value="content") ArquivoContent content) {
        this();
        this.id = id;
        this.nome = nome;
        this.dataCriacao = dataCriacao;
        this.content.setId(id);
        if (content != null) {
            this.content.setBinary(content.getBinary());
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public static Arquivo of(Long id, String nome) {
        Arquivo arquivo = new Arquivo();
        arquivo.setId(id);
        arquivo.nome = nome;
        return arquivo;
    }

    public ArquivoContent getContent() {
        return this.content;
    }

    public void setContent(ArquivoContent content) {
        this.content = content;
    }

    @NotEmpty
    @Length(max=2000)
    public @NotEmpty @Length(max=2000) String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public LocalDate getDataCriacao() {
        return this.dataCriacao;
    }

    public void setDataCriacao(LocalDate dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Generated
    public String toString() {
        return "Arquivo(id=" + this.getId() + ", nome=" + this.getNome() + ", dataCriacao=" + this.getDataCriacao() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arquivo)) {
            return false;
        }
        Arquivo other = (Arquivo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Arquivo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

