SELECT NOME,
	CASE WHEN TIPOPESSOA = 'F'
	THEN '**' + SUBSTRING(CNPJCPF, 3,5) + '****'
	ELSE 
	     '**' + SUBSTRING(CNPJCPF, 3,6) + '******'
	END AS CNPJCPF,
	CNPJCPFDB,
	VALOR
FROM (
	SELECT
	    ROW_NUMBER() OVER(ORDER BY P.NOME) AS ORDERID,
	    P.NOME AS NOME,
	    P.CGCCPF AS CNPJCPF,
	    P.CGCCPF AS CNPJCPFDB,
	    P.TIPOPESSOA AS TIPOPESSOA,
	    VP.SITUACAO AS SITUACAO,
	    SUM(VP.VALOR) AS VALOR
	FROM CADASTROGERAL CG 
	    JOIN CGCM P 
	       ON P.CODIGO = CG.CODIGOCGCM
	    JOIN VALORESPARCELAS VP 
	        ON VP.TIPOCADASTRO = CG.TIPO
	        AND VP.CODIGOIMOVEL = CG.CODIGO
	WHERE VP.SITUACAO IN (1,2)
	$[FILTRO]
	GROUP BY P.NOME, P.CGCCPF, P.TIPOPESSOA, VP.SITUACAO
) V WHERE V.ORDERID BETWEEN :start AND :end;
