SELECT X.* 
  FROM (
SELECT F.MATRICULA, 
       MP.TIPOMOVIMENTACAO,
       FP.NOME, 
       (CASE 
           WHEN MP.TIPOMOVIMENTACAO = 90 THEN ML.HISTORICO
           WHEN MP.TIPOMOVIMENTACAO = 23 THEN AF.CARGOCEDIDO
        END) CARGOCEDIDO,
       ATO.DESCRICAO AS ATOCEDIDO,
       ATO.NUMEROATO,
       ATO.ANOATO,
       TIPOATO.DESCRICAO AS TIPOATO,
       (CASE 
           WHEN MP.TIPOMOVIMENTACAO = 90 AND ML.TIPOBENEFICIO = 'S' THEN 'CEDIDO SEM ÔNUS'
           WHEN MP.TIPOMOVIMENTACAO = 90 AND ML.TIPOBENEFICIO = 'C' THEN 'CEDIDO COM ÔNUS'
           WHEN MP.TIPOMOVIMENTACAO = 90 AND ML.TIPOBENEFICIO = 'G' THEN 'CEDIDO COM GRATIFICAÇÃO'
           WHEN MP.TIPOMOVIMENTACAO = 23 AND AF.TIPO = '6' THEN 'CEDIDO SEM ÔNUS'
           WHEN MP.TIPOMOVIMENTACAO = 23 AND AF.TIPO = '7' THEN 'CEDIDO COM ÔNUS'
           ELSE 'SEM INFORMAÇÃO'
        END) TIPOCEDIDO,
       (CASE 
           WHEN MP.TIPOMOVIMENTACAO = 90 THEN COALESCE(PML.NOME,'SEM INFORMAÇÃO DE ORIGEM')
           WHEN MP.TIPOMOVIMENTACAO = 23 THEN COALESCE(PAF.NOME,'SEM INFORMAÇÃO DO DESTINO')
        END) LOCALCEDIDO,
       COALESCE(AF.DATAINICIAL, ML.DATABENEFICIO) DATAINICIO,
       COALESCE(CASE WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= :dataAtual 
                   THEN F.DATASITUACAO 
                   ELSE AF.DATAFINAL 
                END, ML.DATATERMINO) DATAFIM
  FROM RHFUNCIONARIO F
  JOIN RHMOVIMENTACAOPESSOAL MP
    ON F.ENTIDADE = MP.ENTIDADE
   AND F.MATRICULA = MP.MATRICULA
  LEFT OUTER JOIN CGATO ATO
    ON MP.ENTIDADE = ATO.ENTIDADE
   AND MP.IDATO = ATO.IDATO
  LEFT OUTER JOIN CGTIPOATO TIPOATO
    ON ATO.TIPOATO = TIPOATO.TIPOATO
  JOIN RHTIPOMOVIMENTACAO TM
    ON MP.TIPOMOVIMENTACAO = TM.TIPOMOVIMENTACAO
  LEFT OUTER JOIN RHMOVIMENTACAOLEGAL ML
    ON MP.ENTIDADE = ML.ENTIDADE
   AND MP.MATRICULA = ML.MATRICULA
   AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
  LEFT OUTER JOIN RHMOVIMENTACAOAFASTAMENTO AF
    ON MP.ENTIDADE = AF.ENTIDADE
   AND MP.MATRICULA = AF.MATRICULA
   AND MP.MOVIMENTACAO = AF.MOVIMENTACAO
  LEFT OUTER JOIN PESSOA PML
    ON ML.PESSOA = PML.PESSOA
  LEFT OUTER JOIN PESSOA PAF
    ON AF.PESSOA = PAF.PESSOA
  LEFT OUTER JOIN PESSOA FP
    ON F.PESSOA = FP.PESSOA
 WHERE F.ENTIDADE = :entidade
   AND MP.TIPOMOVIMENTACAO = :tipoMovimentacao
   $[FILTRO]) X