SELECT 
  F.ENTIDADE,  
  TRIM(P.NOME) AS NOME,  
  F.MATRICULA,  
  SF.SITUACAO,
  CASE WHEN F.SITUACAO = 3 AND F.DATASITUACAO <= :dataAtual THEN F.DATASITUACAO ELSE NULL END AS DATADEMISSAO,
  C.DESCRICAO AS DESCRICAOCARGO,  
  CL.DESCRICAO AS DESCRICAOCLASSE,  
  RDC.DESCRICAO AS DESCRICAONATUREZA,
  RL.DESCRICAO AS DESCRICAOLOTACAO
  FROM RHFUNCIONARIO F   
   LEFT OUTER JOIN PESSOA  P   
     ON F.PESSOA = P.PESSOA  
   LEFT OUTER JOIN VW_SITUACAOFUNCIONARIO SF
     ON F.ENTIDADE = SF.ENTIDADE
     AND F.MATRICULA = SF.MATRICULA
   LEFT OUTER JOIN RHCARGO C   
     ON F.ENTIDADE = C.ENTIDADE     
    AND F.CARGO = C.CARGO    
   LEFT OUTER JOIN RHCLASSE CL   
     ON F.ENTIDADE = CL.ENTIDADE     
    AND F.CLASSE = CL.CLASSE    
   LEFT OUTER JOIN RHDEFINICAOCLASSE RDC       
     ON CL.DEFINICAO = RDC.DEFINICAO     
   LEFT OUTER JOIN RHLOTACAO RL       
     ON F.ENTIDADE = RL.ENTIDADE      
    AND F.MODELOLOTACAO = RL.MODELOLOTACAO      
    AND F.NIVELLOTACAO = RL.NIVELLOTACAO      
    AND F.LOTACAO = RL.LOTACAO  
  WHERE F.ENTIDADE = :entidade
    AND ((F.SITUACAO <> 3) OR (F.SITUACAO = 3 AND F.DATASITUACAO >= INICIOCOMPETENCIA(:exercicio,01)))
    AND EXISTS ( 
            SELECT MP.MATRICULA
              FROM RHMOVIMENTACAOPESSOAL MP
              JOIN RHMOVIMENTACAOLEGAL ML ON MP.ENTIDADE = ML.ENTIDADE
               AND MP.MATRICULA = ML.MATRICULA
               AND MP.MOVIMENTACAO = ML.MOVIMENTACAO
             WHERE MP.MATRICULA = F.MATRICULA
               AND MP.ENTIDADE = F.ENTIDADE
               AND MP.TIPOMOVIMENTACAO IN (39, 67)
               AND EXTRACT(YEAR FROM ML.DATABENEFICIO)  <= :exercicio
        )
    AND EXTRACT(YEAR FROM F.DATAADMISSAO) <= :exercicio
