/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.resource;

import br.com.elotech.core.web.ui.BaseExport;
import br.com.elotech.core.web.ui.ReportParam;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.MovimentacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.EntidadeContabilidadeRepository;
import br.com.elotech.portaltransparencia.contabportal.service.MovimentacaoService;
import br.com.elotech.portaltransparencia.web.rest.params.PesquisaMovimentacaoParams;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/movimentacao"})
public class MovimentacaoResource {
    private final MovimentacaoService movimentacaoService;
    private final BaseExport baseExport;
    private final EntidadeContabilidadeRepository entidadeRepository;

    public MovimentacaoResource(MovimentacaoService movimentacaoService, BaseExport baseExport, EntidadeContabilidadeRepository entidadeRepository) {
        this.movimentacaoService = movimentacaoService;
        this.baseExport = baseExport;
        this.entidadeRepository = entidadeRepository;
    }

    @GetMapping(params={"entidade", "exercicio", "centroCusto", "item"})
    public ResponseEntity<List<MovimentacaoDTO>> findMovimentacoes(PesquisaMovimentacaoParams params) {
        return ResponseEntity.ok((Object)this.movimentacaoService.findMovimentacoes(params));
    }

    @GetMapping(value={"/report"})
    public ModelAndView export(HttpServletRequest request, HttpServletResponse response, PesquisaMovimentacaoParams params) throws Throwable {
        List movimentacoes = this.movimentacaoService.findMovimentacoes(params);
        Entidade entidadeObj = (Entidade)this.entidadeRepository.findOne((Object)params.getEntidade());
        ReportParam reportParam = new ReportParam();
        reportParam.setNomeEntidade(entidadeObj.getNome());
        reportParam.setClazzDTO(MovimentacaoDTO.class);
        String tipoMovimentacao = "";
        String nomeHeaderField = "";
        String nomeField = "";
        if (params.getTipo().equals("ENTRADA")) {
            movimentacoes = movimentacoes.stream().filter(m -> m.getTipo().equals("ENTRADA")).collect(Collectors.toList());
            tipoMovimentacao = "Entrada";
            nomeHeaderField = "Fornecedor";
            nomeField = "fornecedorDescricao";
        } else if (params.getTipo().equals("SAIDA")) {
            movimentacoes = movimentacoes.stream().filter(m -> m.getTipo().equals("SAIDA")).collect(Collectors.toList());
            tipoMovimentacao = "Sa\u00edda";
            nomeHeaderField = "Consumidor";
            nomeField = "centroCustoConsumoDescricao";
        }
        reportParam.setReportTitle(String.format("Movimenta\u00e7\u00f5es de %s Almoxarifado", tipoMovimentacao));
        reportParam.setHeaderFields(String.format("%s,Data,N\u00famero,N\u00famero Nota,Quantidade,Unidade,Valor Unit\u00e1rio,Valor Total", nomeHeaderField));
        reportParam.setFields(String.format("%s,data,numero,numeroNota,quantidade,unidade,valorUnitario,valorTotal", nomeField));
        float[] fieldsPerc = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        reportParam.setWidthsFieldsPerc(fieldsPerc);
        int[] fieldTab = new int[]{100, 20, 20, 20, 20, 20, 20, 20};
        reportParam.setWidthsFieldsTab(fieldTab);
        reportParam.setItems(movimentacoes);
        reportParam.setFontSize(6.0f);
        reportParam.setRequest(request);
        reportParam.setResponse(response);
        reportParam.setReportType(params.getExportType());
        return this.baseExport.toExport(reportParam);
    }
}

