/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindExercicioParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.PatrimonioAlienacao;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.UltimaAtualizacaoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoArquivoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoDTO;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.VeiculoGastoManutencaoDTO;
import br.com.elotech.portaltransparencia.contabportal.repository.VeiculoCustomRepository;
import br.com.elotech.portaltransparencia.contabportal.resource.params.VeiculoParams;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class VeiculoRepositoryImpl
implements VeiculoCustomRepository {
    private static final String TIPO_POR_DATAGASTO = "1";
    private static final String TIPO_POR_DATAREQUISICAO = "2";
    private static final String SQL_DATAGASTO = "db/sql/contab/veiculo-gastos-por-data-gasto.sql";
    private static final String SQL_DATAREQUISICAO = "db/sql/contab/veiculo-gastos-por-data-requisicao.sql";
    private static final String LIST_ALINIENACOES_VEICULOS = "db/sql/contab/veiculo-alienacao.sql";
    private static final String VEICULO = "db/sql/contab/veiculo.sql";
    private static final String GASTOS_MANUTENCAO = "db/sql/contab/veiculo-gastos-manutencao.sql";
    private static final String GASTOS_BATERIA = "db/sql/contab/veiculo-gastos-bateria.sql";
    private static final String GASTOS_PNEU = "db/sql/contab/veiculo-gastos-pneu.sql";
    private static final String GASTOS_ABASTECIMENTO = "db/sql/contab/veiculo-gastos-abastecimento.sql";
    private static final String ULTIMA_ATUALIZACAO = "db/sql/contab/ultimaAtualizacaoFrota.sql";
    private static final String SQL_VEICULO_ARQUIVO = "db/sql/contab/veiculoArquivos.sql";
    private final DatasourceWrapper datasourceWrapper;

    public VeiculoRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<VeiculoGastoDTO> getGastosVeiculo(VeiculoParams params, String tipoGasto) {
        StringBuilder sql = new StringBuilder();
        if (TIPO_POR_DATAGASTO.equals(tipoGasto)) {
            sql.append(FileUtils.readResourceAsString((String)SQL_DATAGASTO));
        } else if (TIPO_POR_DATAREQUISICAO.equals(tipoGasto)) {
            sql.append(FileUtils.readResourceAsString((String)SQL_DATAREQUISICAO));
        } else {
            return new ArrayList<VeiculoGastoDTO>();
        }
        MapSqlParameterSource parameter = params.toJdbcParameter();
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoGastoDTO.class));
    }

    public List<PatrimonioAlienacao> findAlienacoes() {
        String sql = FileUtils.readResourceAsString((String)LIST_ALINIENACOES_VEICULOS);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (RowMapper)new ElotechBeanPropertyRowMapper(PatrimonioAlienacao.class));
    }

    public VeiculoDTO findVeiculo(VeiculoParams params) {
        String sql = FileUtils.readResourceAsString((String)VEICULO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoDTO.class)).stream().findFirst().orElse(null);
    }

    public List<VeiculoArquivoDTO> findVeiculoArquivos(VeiculoParams params) {
        String sql = FileUtils.readResourceAsString((String)SQL_VEICULO_ARQUIVO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoArquivoDTO.class));
    }

    public List<VeiculoGastoManutencaoDTO> findGastosManutencaoByVeiculo(VeiculoParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_MANUTENCAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoGastoManutencaoDTO.class));
    }

    public List<VeiculoGastoManutencaoDTO> findGastosBateriaByVeiculo(VeiculoParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_BATERIA);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoGastoManutencaoDTO.class));
    }

    public List<VeiculoGastoManutencaoDTO> findGastosAbastecimentoByVeiculo(VeiculoParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_ABASTECIMENTO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoGastoManutencaoDTO.class));
    }

    public List<VeiculoGastoManutencaoDTO> findGastosPneuByVeiculo(VeiculoParams params) {
        String sql = FileUtils.readResourceAsString((String)GASTOS_PNEU);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(VeiculoGastoManutencaoDTO.class));
    }

    public List<UltimaAtualizacaoDTO> findUltimaAtualizacao(FindExercicioParams params) {
        String sql = FileUtils.readResourceAsString((String)ULTIMA_ATUALIZACAO);
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(UltimaAtualizacaoDTO.class));
    }
}

