/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.contabportal.domain.dto.FornecedorAPagarDTO;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import br.com.elotech.portaltransparencia.web.rest.params.FornecedorAPagarParams;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FornecedorAPagarRepository {
    private static final String FORNECEDORAPAGAR = "db/sql/contab/fornecedorAPagar.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public FornecedorAPagarRepository(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    private Long getCount(String sql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("SELECT COUNT(*) AS TOTAL");
        sqlCount.append(" FROM (");
        sqlCount.append(sql);
        sqlCount.append(") X");
        return (Long)this.datasourceWrapper.getJdbcTemplate().queryForObject(sqlCount.toString(), (SqlParameterSource)new MapSqlParameterSource(), Long.class);
    }

    public Page<FornecedorAPagarDTO> findFornecedores(Pageable pageable, FornecedorAPagarParams params) {
        String sql = FileUtils.readResourceAsString((String)FORNECEDORAPAGAR);
        sql = sql.replace("$[FILTRO]", params.montaFiltro());
        String queryOrder = SqlUtils.aplicaOrdenacao((Pageable)pageable, (String)sql, (String)" ORDER BY X.NOME ");
        String queryPaginado = SqlUtils.aplicaPaginacao((Pageable)pageable, (String)queryOrder, (String)this.datasourceWrapper.getPlatform());
        List list = this.datasourceWrapper.getJdbcTemplate().query(queryPaginado, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(FornecedorAPagarDTO.class));
        return new PageImpl(list, pageable, this.getCount(sql).longValue());
    }

    public FornecedorAPagarDTO findFornecedoresTotais(FornecedorAPagarParams params) {
        String sql = FileUtils.readResourceAsString((String)FORNECEDORAPAGAR);
        String filtro = params.montaFiltro();
        sql = sql.replace("$[FILTRO]", filtro);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT SUM(X.EMPENHADO) AS EMPENHADO,");
        sb.append("       SUM(X.ANULADO) AS ANULADO,");
        sb.append("       SUM(X.LIQUIDADO) AS LIQUIDADO,");
        sb.append("       SUM(X.RETIDO) AS RETIDO,");
        sb.append("       SUM(X.PAGO) AS PAGO,");
        sb.append("       SUM(X.APAGAR) AS APAGAR");
        sb.append(" FROM (       ");
        sb.append(sql);
        sb.append(" ) X");
        List list = this.datasourceWrapper.getJdbcTemplate().query(sb.toString(), (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(FornecedorAPagarDTO.class));
        return (FornecedorAPagarDTO)list.get(0);
    }
}

