/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.resource.params;

import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAditivoParams;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FindAditivoParams {
    private Long entidade;
    private Long exercicio;
    private Long numero;
    private Long sequencia;

    public Optional<Long> getEntidade() {
        return Optional.ofNullable(this.entidade);
    }

    public Optional<Long> getExercicio() {
        return Optional.ofNullable(this.exercicio);
    }

    public Optional<Long> getNumero() {
        return Optional.ofNullable(this.numero);
    }

    public Optional<Long> getSequencia() {
        return Optional.ofNullable(this.sequencia);
    }

    public MapSqlParameterSource toJdbcParameter() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        this.checkEntidade(params);
        this.checkExercicio(params);
        this.checkNumero(params);
        this.checkSequencia(params);
        return params;
    }

    private void checkExercicio(MapSqlParameterSource params) {
        if (Objects.nonNull(this.exercicio)) {
            params.addValue("exercicio", (Object)this.exercicio, 2);
        }
    }

    private void checkEntidade(MapSqlParameterSource params) {
        if (Objects.nonNull(this.entidade)) {
            params.addValue("entidade", (Object)this.entidade, 2);
        }
    }

    private void checkNumero(MapSqlParameterSource params) {
        if (Objects.nonNull(this.numero)) {
            params.addValue("numero", (Object)this.numero, 2);
        }
    }

    private void checkSequencia(MapSqlParameterSource params) {
        if (Objects.nonNull(this.sequencia)) {
            params.addValue("sequencia", (Object)this.sequencia, 2);
        }
    }

    @Generated
    public static FindAditivoParamsBuilder builder() {
        return new FindAditivoParamsBuilder();
    }

    @Generated
    public String toString() {
        return "FindAditivoParams(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", numero=" + this.getNumero() + ", sequencia=" + this.getSequencia() + ")";
    }

    @Generated
    public FindAditivoParams() {
    }

    @Generated
    public FindAditivoParams(Long entidade, Long exercicio, Long numero, Long sequencia) {
        this.entidade = entidade;
        this.exercicio = exercicio;
        this.numero = numero;
        this.sequencia = sequencia;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Generated
    public void setSequencia(Long sequencia) {
        this.sequencia = sequencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAditivoParams)) {
            return false;
        }
        FindAditivoParams other = (FindAditivoParams)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Optional this$entidade = this.getEntidade();
        Optional other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Optional this$exercicio = this.getExercicio();
        Optional other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Optional this$numero = this.getNumero();
        Optional other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !((Object)this$numero).equals(other$numero)) {
            return false;
        }
        Optional this$sequencia = this.getSequencia();
        Optional other$sequencia = other.getSequencia();
        return !(this$sequencia == null ? other$sequencia != null : !((Object)this$sequencia).equals(other$sequencia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindAditivoParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Optional $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Optional $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : ((Object)$numero).hashCode());
        Optional $sequencia = this.getSequencia();
        result = result * 59 + ($sequencia == null ? 43 : ((Object)$sequencia).hashCode());
        return result;
    }
}

