/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.aiseportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ArrecadacaoBairroDTO;
import br.com.elotech.portaltransparencia.aiseportal.domain.dto.ArrecadacaoDTO;
import br.com.elotech.portaltransparencia.aiseportal.repository.ArrecadacaoRepository;
import br.com.elotech.portaltransparencia.aiseportal.resource.params.ArrecadacaoParams;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import br.com.elotech.portaltransparencia.utils.SqlUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoRepositoryImpl
implements ArrecadacaoRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrecadacaoRepositoryImpl.class);
    private static final String RECEITAS_ARRECADACAO = "db/sql/aise/receitas-arrecadacao.sql";
    private static final String RECEITAS_ARRECADACAO_BAIRROS = "db/sql/aise/receitas-arrecadacao-por-bairros.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public ArrecadacaoRepositoryImpl(@Qualifier(value="wrapperAise") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<ArrecadacaoDTO> findReceitasArrecadacao(ArrecadacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_ARRECADACAO);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoDTO.class));
    }

    public List<ArrecadacaoBairroDTO> findReceitasArrecadacaoPorBairros(ArrecadacaoParams params) {
        String sql = FileUtils.readResourceAsString((String)RECEITAS_ARRECADACAO_BAIRROS);
        sql = params.getLogradouro().isPresent() ? sql.replace("$[filtroLogradouro]", SqlUtils.andLike((String)"LOGR.DESCRICAO", (String)((String)params.getLogradouro().get()))) : sql.replace("$[filtroLogradouro]", "");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
            LOGGER.debug(params.toString());
        }
        return this.datasourceWrapper.getJdbcTemplate().query(sql, (SqlParameterSource)params.toJdbcParameter(), (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoBairroDTO.class));
    }
}

