/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.admportal.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.portaltransparencia.admportal.domain.Rota;
import br.com.elotech.portaltransparencia.admportal.repository.RotaRepositoryCustom;
import br.com.elotech.portaltransparencia.config.DatasourceWrapper;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RotaRepositoryImpl
implements RotaRepositoryCustom {
    private static final String ROTAS_TEMPLATE_ENTIDADE = "db/sql/contab/rotas-template-entidade.sql";
    private final DatasourceWrapper datasourceWrapper;

    @Autowired
    public RotaRepositoryImpl(@Qualifier(value="wrapperContabilidade") DatasourceWrapper datasourceWrapper) {
        this.datasourceWrapper = datasourceWrapper;
    }

    public List<Rota> findRotasAcessiveisByTemplatePadraoDaEntidade(Long template) {
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)ROTAS_TEMPLATE_ENTIDADE));
        return this.datasourceWrapper.getJdbcTemplate().query(sql.toString(), (SqlParameterSource)this.toJdbcParameter(template), (RowMapper)new ElotechBeanPropertyRowMapper(Rota.class));
    }

    private MapSqlParameterSource toJdbcParameter(Long template) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (Objects.nonNull(template)) {
            params.addValue("template", (Object)template, 2);
        }
        return params;
    }
}

