SELECT B.DATA, SUM(CASE C.DEBCRED WHEN 'D' THEN C.VALOR ELSE C.VALOR * -1 END) AS VALOR, CB.DESCRICAO AS LOCAL
  FROM EVENTOSLANCADOSCONTA C
  LEFT OUTER JOIN EVENTOSLANCADOS B
    ON B.ENTIDADE = C.ENTIDADE
   AND B.EXERCICIO = C.EXERCICIO
   AND B.TIPOEVENTO = C.TIPOEVENTO
   AND B.GRUPOEVENTO = C.GRUPOEVENTO
   AND B.EVENTO = C.EVENTO
   AND B.NROLANCAMENTO = C.NROLANCAMENTO
  LEFT JOIN EVENTOSLANCADOSCONTA C1
    ON C1.ENTIDADE = C.ENTIDADE
   AND C1.EXERCICIO = C.EXERCICIO
   AND C1.TIPOEVENTO = C.TIPOEVENTO
   AND C1.GRUPOEVENTO = C.GRUPOEVENTO
   AND C1.EVENTO = C.EVENTO
   AND C1.NROLANCAMENTO = C.NROLANCAMENTO
   AND C1.SEQUENCIA = C.SEQUENCIA
   AND C1.DEBCRED <> C.DEBCRED
  LEFT JOIN CONTACORRENTE CC
    ON CC.ENTIDADE = C1.ENTIDADE
   AND CC.IDCONTACORRENTE = C1.IDCONTACORRENTE
  LEFT JOIN CONTABANCARIAVINCULO CV
    ON CV.ENTIDADE = CC.ENTIDADE
   AND CV.ID = CC.IDCONTABANCARIAVINCULO
  LEFT JOIN CONTABANCARIA CB
    ON CB.ENTIDADE = CV.ENTIDADE
   AND CB.REDUZIDO = CV.REDUZIDO
 WHERE C.ENTIDADE = :entidade
   AND C.EXERCICIO = :exercicio
   AND C.GRUPOEVENTO NOT IN (80,81,85,86)
   AND C.CONTA = :conta
   AND C.IDCONTACORRENTE = :idContaCorrente
 GROUP BY B.DATA, CB.DESCRICAO ORDER BY B.DATA 