SELECT A.ENTIDADE, A.EXERCICIO, A.IDORDEMSERVICO,
	 A.SEQUENCIA, A.DATA, 
	 CASE WHEN A.ADITIVO IS NULL THEN 'Contrato'
	      WHEN A.ADITIVO IS NOT NULL THEN 'Aditivo '|| AD.DESCRICAO
	 END AS ADITIVO, 
	 ATO.ARQUIVO,
	 (SELECT C.IDARQUIVO FROM CGATO C WHERE C.ENTIDADE = A.ENTIDADE AND C.IDATO = ATO.IDATO) AS IDARQUIVO,
	 T.DESCRICAO AS TIPOACOMPANHAMENTO, A.PERCENTUAL,
	 (SELECT COALESCE(SUM(X.PERCENTUAL),0) FROM OBRAACOMPANHAMENTO X
	 WHERE X.ENTIDADE = A.ENTIDADE
	     AND X.EXERCICIO = A.EXERCICIO
	     AND X.IDORDEMSERVICO = A.IDORDEMSERVICO
	     AND (X.ADITIVO = A.ADITIVO OR (A.ADITIVO IS NULL AND X.ADITIVO IS NULL))
	     AND X.SEQUENCIA < A.SEQUENCIA
	     AND X.DATA <= A.DATA) + A.PERCENTUAL AS ACUMULADO,
	 (SELECT COALESCE(COUNT(*),0) FROM OBRAACOMPANHAMENTOIMAGEM B
	   WHERE B.ENTIDADE = A.ENTIDADE
	   AND B.EXERCICIO = A.EXERCICIO
	   AND B.IDORDEMSERVICO = A.IDORDEMSERVICO
	   AND B.ACOMPANHAMENTO = A.SEQUENCIA) AS EXISTEIMAGEM,
	   ATO.IDATO
	 FROM OBRAACOMPANHAMENTO A
	 LEFT OUTER JOIN OBRAORDEMSERVICO OS ON
	   A.ENTIDADE = OS.ENTIDADE
	   AND A.EXERCICIO = OS.EXERCICIO
	   AND A.IDORDEMSERVICO = OS.IDORDEMSERVICO
	 LEFT OUTER JOIN OBRAEMPRESACONTRATOADITIVO AD ON
	   OS.IDEMPRESACONTRATO = AD.IDEMPRESACONTRATO
	   AND A.ADITIVO = AD.ADITIVO
	 LEFT OUTER JOIN OBRATIPOACOMPANHAMENTO T ON
	   A.IDTIPOACOMPANHAMENTO = T.IDTIPOACOMPANHAMENTO
	 LEFT OUTER JOIN OBRALAUDOMEDICAO LM ON
		A.IDLAUDOMEDICAO = LM.IDLAUDOMEDICAO
	 LEFT OUTER JOIN CGATO ATO ON
		LM.ENTIDADE = ATO.ENTIDADE
		 AND LM.IDATO = ATO.IDATO
	 WHERE A.ENTIDADE = :entidade
		 AND A.EXERCICIO = :exercicioObra
		 AND A.IDORDEMSERVICO = :idOrdemServico
	 ORDER BY COALESCE(A.ADITIVO,0), A.DATA, A.SEQUENCIA