SELECT 
    P.NOME,
    CASE
    	WHEN P.TIPOPESSOA = 'F'
    	THEN '**' || SUBSTR(P.CNPJ_CPF,3,5) || '****'
    	ELSE '**' || SUBSTR(P.CNPJ_CPF,3,6) || '******'
    END AS CNPJCPF,
    P.CNPJ_CPF AS CNPJCPFDB,
    SUM(TDPR.VALOR) AS VALOR
FROM TRIBDEBITOPARCELARECEITA TDPR
    LEFT OUTER JOIN TRIBDEBITOPARCELA TDP  
        ON TDP.ENTIDADE = TDPR.ENTIDADE
        AND TDP.EXERCICIO = TDPR.EXERCICIO
        AND TDP.TIPOCADASTRO = TDPR.TIPOCADASTRO
        AND TDP.CADASTROGERAL = TDPR.CADASTROGERAL
        AND TDP.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO
        AND TDP.SUBDIVIDA = TDPR.SUBDIVIDA
        AND TDP.PARCELA = TDPR.PARCELA
    LEFT OUTER JOIN TRIBCADASTROGERAL CG
        ON TDP.TIPOCADASTRO = CG.TIPOCADASTRO
        AND TDP.CADASTROGERAL = CG.CADASTROGERAL
    LEFT OUTER JOIN PESSOA P 
       ON P.PESSOA = CG.PESSOA 
    LEFT OUTER JOIN TRIBSITUACAOPARCELA TSP
       ON TSP.SITUACAOPARCELA = TDP.SITUACAODEBITO
    LEFT OUTER JOIN TRIBTIPOSITUACAOPARCELA TTSP
       ON TSP.TIPOSITUACAOPARCELA = TTSP.TIPOSITUACAOPARCELA
    LEFT OUTER JOIN TRIBPROTESTO TPROTESTO
       ON TDP.IDPROTESTO = TPROTESTO.IDPROTESTO
WHERE TDP.SITUACAOLEGAL IN (1,2)
    AND TTSP.TIPO = 'A'
$[FILTRO]
GROUP BY P.NOME, CASE WHEN P.TIPOPESSOA = 'F'  THEN '**' || SUBSTR(P.CNPJ_CPF,3,5) || '****' ELSE '**' || SUBSTR(P.CNPJ_CPF,3,6) || '******' END, P.CNPJ_CPF
ORDER BY P.NOME