/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.contabportal.service;

import br.com.elotech.portaltransparencia.contabportal.domain.ConfiguracaoInterface;
import br.com.elotech.portaltransparencia.contabportal.domain.Entidade;
import br.com.elotech.portaltransparencia.contabportal.domain.Exercicio;
import br.com.elotech.portaltransparencia.contabportal.domain.ExercicioPK;
import br.com.elotech.portaltransparencia.contabportal.domain.QExercicio;
import br.com.elotech.portaltransparencia.contabportal.repository.ExercicioRepository;
import br.com.elotech.portaltransparencia.contabportal.service.ConfiguracaoService;
import br.com.elotech.portaltransparencia.contabportal.service.EntidadeContabilidadeService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ExercicioService {
    private static final Long ANOFINAL = 9999L;
    private final ExercicioRepository exercicioRepository;
    private final ConfiguracaoService configuracaoService;
    private final EntidadeContabilidadeService entidadeService;

    public ExercicioService(ExercicioRepository exercicioRepository, ConfiguracaoService configuracaoService, EntidadeContabilidadeService entidadeService) {
        this.exercicioRepository = exercicioRepository;
        this.configuracaoService = configuracaoService;
        this.entidadeService = entidadeService;
    }

    public List<Exercicio> getExercicios(Long idEntidade) {
        Entidade entidade = this.entidadeService.findOne(idEntidade);
        Optional configuracao = this.configuracaoService.getConfiguracaoOptional();
        Long anoInicial = 0L;
        Long anoFinal = ANOFINAL;
        if (configuracao.isPresent()) {
            if (Objects.nonNull(((ConfiguracaoInterface)configuracao.get()).getAnoInicial())) {
                anoInicial = ((ConfiguracaoInterface)configuracao.get()).getAnoInicial();
            }
            if (Objects.nonNull(((ConfiguracaoInterface)configuracao.get()).getAnoFinal())) {
                anoFinal = ((ConfiguracaoInterface)configuracao.get()).getAnoFinal();
            }
        }
        Iterable exerciciosIterable = this.exercicioRepository.findAll((Predicate)QExercicio.exercicio.id().entidade().eq((Object)entidade).and((Predicate)QExercicio.exercicio.id().exercicio.between((Number)anoInicial, (Number)anoFinal)), this.sortByIdDesc());
        return Lists.newArrayList((Iterable)exerciciosIterable);
    }

    private Sort sortByIdDesc() {
        return new Sort(Sort.Direction.DESC, new String[]{"id.exercicio"});
    }

    public Optional<Exercicio> findExercicioPadrao() {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        return this.getExercicios(((Entidade)entidadePrincipal.get()).getId()).stream().findFirst();
    }

    public Exercicio findOne(ExercicioPK pk) {
        return (Exercicio)this.exercicioRepository.findOne((Object)pk);
    }

    public Long findModeloDespesa(Long entidade, Long exercicio) {
        ExercicioPK exercicioPK = new ExercicioPK(Entidade.of((Long)entidade), exercicio);
        return ((Exercicio)this.exercicioRepository.findOne((Object)exercicioPK)).getModeloDespesa().getId();
    }
}

