/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portaltransparencia.comprasportal.service.impl;

import br.com.elotech.portaltransparencia.arquivoportal.repository.EloArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.domain.AditivoArquivo;
import br.com.elotech.portaltransparencia.comprasportal.domain.dto.AditivoDTO;
import br.com.elotech.portaltransparencia.comprasportal.repository.AditivoArquivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.repository.AditivoRepository;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindAditivoParams;
import br.com.elotech.portaltransparencia.comprasportal.resource.params.FindContratoParams;
import br.com.elotech.portaltransparencia.comprasportal.service.AditivoService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AditivoServiceImpl
implements AditivoService {
    private final AditivoRepository aditivoRepository;
    private final AditivoArquivoRepository aditivoArquivoRepository;
    private final EloArquivoRepository eloArquivoRepository;

    @Autowired
    public AditivoServiceImpl(AditivoRepository aditivoRepository, AditivoArquivoRepository aditivoArquivoRepository, EloArquivoRepository eloArquivoRepository) {
        this.aditivoRepository = aditivoRepository;
        this.aditivoArquivoRepository = aditivoArquivoRepository;
        this.eloArquivoRepository = eloArquivoRepository;
    }

    public List<AditivoDTO> findAditivos(FindContratoParams findContratoParams) {
        return this.aditivoRepository.findAditivos(findContratoParams);
    }

    public AditivoDTO findAditivo(FindAditivoParams findAditivoParams) {
        return this.aditivoRepository.findAditivo(findAditivoParams);
    }

    public List<AditivoArquivo> findArquivos(FindAditivoParams params) {
        if (!params.getEntidade().isPresent() && !params.getExercicio().isPresent()) {
            return new ArrayList<AditivoArquivo>();
        }
        List aditivoArquivos = this.aditivoArquivoRepository.findByEntidadeAndExercicioAndNumeroAndSequencia((Long)params.getEntidade().get(), (Long)params.getExercicio().get(), (Long)params.getNumero().get(), (Long)params.getSequencia().get());
        aditivoArquivos.stream().filter(AditivoArquivo::possuiEloArquivo).map(AditivoArquivo::getArquivoCompras).forEach(a -> a.setTamanhoArquivo(this.eloArquivoRepository.getTamanhoArquivo(a.getArquivo().getId())));
        return aditivoArquivos;
    }
}

