select filtro.idTipoAtualizacaoCredito, 
       filtro.dtAtualizacao, 
       filtro.nrcredito, 
       filtro.nranocredito, 
       filtro.idpagamentobloqueto, 
       filtro.iddebitoparcelareceita, 
       filtro.idCreditoContribuinteItem, 
       filtro.idparcelamento, 
       filtro.vlAtualizacao, 
       ca.idTce as cdControleLeiAto
from ( 
  select 1 as idTipoAtualizacaoCredito, 
         tpd.valorjuros as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         0 as idparcelamento, 
         tp.datapagamento as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribpagamento tp 
  join tribpagamentobloqueto tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento 
  join tribpagamentodebito   tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0 and tpd.situacaolegal = 0 and tpd.valorpago > 0 
  join tcedebitolanccredito  tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
  join tcelanccredito        tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists ( 
       select 1 
       from tceAtualizaMonePagamento tamp 
       where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto 
         and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
    ) 
  union all 
  select 2 as idTipoAtualizacaoCredito, 
         tpd.valormulta as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         0 as idparcelamento, 
         tp.datapagamento as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribpagamento tp 
  join tribpagamentobloqueto tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento 
  join tribpagamentodebito   tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0 and tpd.situacaolegal = 0 and tpd.valorpago > 0 
  join tcedebitolanccredito  tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
  join tcelanccredito        tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists ( 
       select 1 
       from tceAtualizaMonePagamento tamp 
       where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto 
         and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
    ) 
  union all 
  select 3 as idTipoAtualizacaoCredito, 
         tpd.valorcorrecao as vlAtualizacao, 
         tpd.idpagamentobloqueto, 
         tpd.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         0 as idparcelamento, 
         tp.datapagamento as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribpagamento tp 
  join tribpagamentobloqueto tpb  on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento 
  join tribpagamentodebito   tpd  on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0 and tpd.situacaolegal = 0 and tpd.valorpago > 0 
  join tcedebitolanccredito  tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
  join tcelanccredito        tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tp.entidade = :entidade 
    and tp.datapagamento BETWEEN :dataInicial and :dataFinal 
    and not exists ( 
       select 1 
       from tceAtualizaMonePagamento tamp 
       where tamp.idpagamentobloqueto = tpd.idpagamentobloqueto 
         and tamp.iddebitoparcelareceita = tpd.iddebitoparcelareceita 
    ) 
  union all 
  select 1 as idTipoAtualizacaoCredito, 
         tcci.valorjuros as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         0 as idparcelamento, 
         tcc.datacredito as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  join tcedebitolanccredito        tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tcelanccredito              tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tcc.entidade = :entidade 
    and tcc.datacredito BETWEEN :dataInicial and :dataFinal 
    and tcci.valorjuros > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal = 0 
    and not exists ( 
       select 1 
       from tceatualizamonecredito tamc 
       where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem 
         and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
    ) 
  union all 
  select 2 as idTipoAtualizacaoCredito, 
         tcci.valormulta as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         0 as idparcelamento, 
         tcc.datacredito as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  join tcedebitolanccredito        tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tcelanccredito              tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tcc.entidade = :entidade 
    and tcc.datacredito BETWEEN :dataInicial and :dataFinal 
    and tcci.valormulta > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal = 0 
    and not exists ( 
       select 1 
       from tceatualizamonecredito tamc 
       where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem 
         and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
    ) 
  union all 
  select 3 as idTipoAtualizacaoCredito, 
         tcci.valorcorrecao as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tcci.iddebitoparcelareceita, 
         tcci.idcreditocontribuinteitem, 
         0 as idparcelamento, 
         tcc.datacredito as dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribcreditocontribuinte     tcc 
  join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte 
  join tribdebitoparcelareceita    tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tribdebitoparcela           tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio  = tdpr.exercicio 
                                       and tdp.tipocadastro  = tdpr.tipocadastro  and tdp.cadastrogeral  = tdpr.cadastrogeral 
                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento  and tdp.subdivida  = tdpr.subdivida 
                                       and tdp.parcela = tdpr.parcela 
  join tcedebitolanccredito        tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
  join tcelanccredito              tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito 
  where tcc.entidade = :entidade 
    and tcc.datacredito BETWEEN :dataInicial and :dataFinal 
    and tcci.valorcorrecao > 0 
    and tcci.valorprincipal > 0 
    and tdp.situacaolegal = 0 
    and not exists ( 
       select 1 
       from tceatualizamonecredito tamc 
       where tamc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem 
         and tamc.iddebitoparcelareceita = tcci.iddebitoparcelareceita 
    ) 
  union all 
  select distinct 
         filtro.idTipoAtualizacaoCredito, 
         sum(round((tppro.percentual/100) * filtro.vlAtualizacao, 2)) as vlAtualizacao, 
         0 as idpagamentobloqueto, 
         tppro.iddebitoparcelareceita, 
         0 as idCreditoContribuinteItem, 
         tppro.idparcelamento, 
         filtro.dtAtualizacao, 
         tlc.nrcredito, 
         tlc.nranocredito 
  from tribParcelamentoParcRecOrigem       tppro 
       join tribdebitoparcelareceita       tdpr on tdpr.iddebitoparcelareceita = tppro.iddebitoparcelareceita 
       join tribdebitoParcela              tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio 
                                               and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral 
                                               and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida 
                                               and tdp.parcela = tdpr.parcela 
       join tribdebito                     td   on td.entidade = tdp.entidade and td.exercicio = tdp.exercicio 
                                               and td.tipocadastro = tdp.tipocadastro and td.cadastrogeral = tdp.cadastrogeral 
                                               and td.guiarecolhimento = tdp.guiarecolhimento and td.subdivida = tdp.subdivida 
  left join tribguiarecolhimento           tg   on tg.entidade =  :entidade
                                               and tg.exercicio =  :exercicio
                                               and tg.guiarecolhimento = td.guiarecolhimento 
       join tribparcelamentoreceitaespelho tgre on tgre.idparcelamento = tppro.idparcelamento and tgre.iddebito = td.iddebito and tgre.receitaorigem = tdpr.receita 
       join 
       ( 
          select case when (tr.classificacao = 'J' or tr.classificacao = 'F') then 1 
                      when (tr.classificacao = 'M') then 2 else 3 end as idTipoAtualizacaoCredito, 
                 tp.dataparcelamento as dtAtualizacao, 
                 tr.classificacao, 
                 tp.idParcelamento, 
                 tpre.receitaorigem as receitaPrincipal, 
                 tr.receita, 
                 sum(tdpr.valor) as vlAtualizacao 
          from tribparcelamento              tp 
          join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento 
          join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
          join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio 
                                                  and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral 
                                                  and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
          join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio 
                                                  and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral 
                                                  and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                                  and tdpr.parcela = tdp.parcela 
          join tribparcelamentoreceitaespelho tpre on tpre.idparcelamento = tp.idparcelamento 
                                                  and tpre.iddebitonovo = td.iddebito 
                                                  and (tpre.jurosdestino = tdpr.receita or tpre.multadestino = tdpr.receita or 
                                                       tpre.correcaodestino = tdpr.receita or tpre.jurosfinandestino = tdpr.receita) 
          left join tribreceita               tr   on tr.entidade =  :entidade
                                                  and tr.exercicio =  :exercicio
                                                  and tr.receita = tdpr.receita 
               join 
               ( 
                  select tr.receita, 
                         tr.classificacao, 
                         tp.idParcelamento 
                  from tribparcelamento                   tp 
                       join tribparcelamentodebitoorigem  tpdo  on tpdo.idParcelamento = tp.idparcelamento 
                       join tribdebito                    td    on td.iddebito = tpdo.iddebitonovo 
                       join tribdebitoparcela             tdp   on tdp.entidade = td.entidade and tdp.exercicio = td.exercicio 
                                                               and tdp.tipocadastro = td.tipocadastro and tdp.cadastrogeral = td.cadastrogeral 
                                                               and tdp.guiarecolhimento = td.guiarecolhimento and tdp.subdivida = td.subdivida 
                       join tribdebitoparcelareceita      tdpr  on tdpr.entidade = tdp.entidade and tdpr.exercicio = tdp.exercicio 
                                                               and tdpr.tipocadastro = tdp.tipocadastro and tdpr.cadastrogeral = tdp.cadastrogeral 
                                                               and tdpr.guiarecolhimento = tdp.guiarecolhimento and tdpr.subdivida = tdp.subdivida 
                                                               and tdpr.parcela = tdp.parcela 
                  left join tribreceita                   tr    on tr.entidade =  :entidade
                                                               and tr.exercicio =  :exercicio
                                                               and tr.receita = tdpr.receita 
                       join tribreceitatipo               trt   on trt.tiporeceita = tr.tiporeceita 
                       join tribclassificacaoreceitatipo  tcrt  on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo 
                  where tp.entidade = :entidade 
                    and trt.classificacaoreceitatipo in (1,2,3,4,5,7) 
                    and tp.dataparcelamento between :dataInicial and :dataFinal 
                    and tr.classificacao = 'P' 
                    and tdp.situacaolegal = 0 
                    and not exists( 
                      select 1 from tceAtualizaMoneParc tamp 
                      where tamp.idparcelamento = tp.idparcelamento 
                    ) 
                  group by tr.receita, tr.classificacao, tp.idparcelamento 
               ) nq on nq.idParcelamento = tp.idparcelamento and nq.receita = tpre.receitaorigem 
          where tr.classificacao in ('J','M','C','F') 
          group by tp.dataparcelamento, 
                   tr.receita, 
                   tr.classificacao, 
                   tp.idparcelamento, 
                   tpre.receitaorigem 
          order by tp.idparcelamento, case when (tr.classificacao = 'J' or tr.classificacao = 'F') then 1 
                                           when (tr.classificacao = 'M') then 2 else 3 end 
       ) filtro on filtro.idparcelamento = tppro.idparcelamento and filtro.receitaPrincipal = tgre.receitaorigem 
  left join tcedebitolanccredito tdlc on tdlc.iddebitoparcelareceita = tppro.iddebitoparcelareceita 
  left join tcelanccredito       tlc  on tlc.idTceLancCredito = tdlc.idtcelanccredito 
  where tdp.situacaolegal = 0 
  group by filtro.idTipoAtualizacaoCredito, 
           tppro.iddebitoparcelareceita, 
           tppro.idparcelamento, 
           filtro.dtAtualizacao, 
           tlc.nrcredito, 
           tlc.nranocredito 
) filtro 
 inner join tribDebitoParcelaReceita tdpr_f on tdpr_f.iddebitoparcelareceita = filtro.iddebitoparcelareceita 
  left join tribguiarecolhimento     tg on tg.entidade =  :entidade
                                       and tg.exercicio =  :exercicio
                                       and tg.guiarecolhimento = tdpr_f.guiarecolhimento 
  left join cgato                    ca on ca.entidade = tg.entidade and ca.idato = tg.fundamentolegal 
order by filtro.dtAtualizacao, 
         filtro.nrcredito, 
         filtro.nranocredito, 
         filtro.idpagamentobloqueto, 
         filtro.iddebitoparcelareceita, 
         filtro.idTipoAtualizacaoCredito;