/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.manutencaoarquivo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoLancamentoCreditoMaDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.repository.AtoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.simam.EstornoLancamentoCreditoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.simam.manutencaoarquivo.ManutencaoArquivoSimAmService;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class EstornoLancamentoCreditoMaService
implements ManutencaoArquivoSimAmService<EstornoLancamentoCreditoMaDTO> {
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private EstornoLancamentoCreditoRepository estornoLancamentoCreditoRepository;
    @Autowired
    private EntidadeRepository entidadeRepository;
    @Autowired
    private ContextService contextService;
    @Autowired
    private AtoRepository atoRepository;

    public TipoRegistroSimAm getTipoRegistroSimAm() {
        return TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO;
    }

    public Page<EstornoLancamentoCreditoMaDTO> find(String search, LocalDate dataInicial, LocalDate dataFinal, Pageable pageable) {
        Specification dateSpecification = (root, query, cb) -> cb.between((Expression)root.get("dtEstorno"), cb.literal((Object)dataInicial), cb.literal((Object)dataFinal));
        Specification specification = StringUtils.isBlank((String)search) ? dateSpecification : dateSpecification.and(RsqlUtils.createSpecFrom((EntityManager)this.entityManager, (String)search));
        return this.estornoLancamentoCreditoRepository.findAll(specification, pageable).map(EstornoLancamentoCreditoMaDTO::from);
    }

    public List<EstornoLancamentoCreditoMaDTO> updateAll(List<EstornoLancamentoCreditoMaDTO> arquivos) {
        if (!this.areArquivosValidos(arquivos)) {
            return arquivos.stream().filter(EstornoLancamentoCreditoMaDTO::hasError).collect(Collectors.toList());
        }
        this.estornoLancamentoCreditoRepository.saveAll((Iterable)arquivos.stream().map(EstornoLancamentoCreditoMaDTO::toEstornoLancamentoCredito).collect(Collectors.toList()));
        return arquivos;
    }

    private boolean areArquivosValidos(List<EstornoLancamentoCreditoMaDTO> arquivos) {
        Long entidade = this.contextService.getEntidadePrincipal();
        AtomicBoolean valido = new AtomicBoolean(true);
        arquivos.forEach(arquivo -> {
            Ato ato = this.atoRepository.findByIdTce(entidade, arquivo.getCdControleLeiAto()).orElse(null);
            Long idTipoEscopoLei = Optional.ofNullable(ato).map(Ato::getIdTipoEscopoLei).orElse(null);
            try {
                this.validateEscopoTributoMunicipal(idTipoEscopoLei, arquivo.getIdTceLancCreditoEst(), arquivo.getCdControleLeiAto());
            }
            catch (Exception e) {
                arquivo.setErrorMessage(e.getMessage());
                valido.set(false);
            }
        });
        return valido.get();
    }

    private void validateEscopoTributoMunicipal(Long idTipoEscopoLei, Long idTceLancCredito, Long cdControleLeiAto) {
        if (Objects.isNull(idTipoEscopoLei) || !idTipoEscopoLei.equals(22L)) {
            throw new EloValidationException(String.format("Regra 1321 - O controle de Lei/Ato %d com c\u00f3digo %d da tabela TceLancCreditoEst n\u00e3o existe na tabela CgAto com idTipoEscopoLei = 22 - Tributos Municipais.", cdControleLeiAto, idTceLancCredito));
        }
    }
}

