/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam;

import br.com.elotech.tributos.dto.SimamGeracaoDadosDTO;
import br.com.elotech.tributos.service.batch.simam.ImplantacaoSaldoJobStarter;
import br.com.elotech.tributos.service.batch.simam.ImplantacaoSaldoMovimentacaoMensalJobStarter;
import br.com.elotech.tributos.service.batch.simam.MovimentacaoMensalJobStarter;
import br.com.elotech.tributos.service.simam.SimAmGeracaoDadosService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Objects;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class SimAmGeracaoDadosService {
    private final ImplantacaoSaldoJobStarter implantacaoSaldoJobStarter;
    private final ImplantacaoSaldoMovimentacaoMensalJobStarter implantacaoSaldoMovimentacaoMensalJobStarter;
    private final MovimentacaoMensalJobStarter movimentacaoMensalJobStarter;

    public void iniciarTarefa(SimamGeracaoDadosDTO dados) throws Exception {
        LocalDate dataInicial = Objects.nonNull(dados.getExercicio()) && Objects.nonNull(dados.getCompetencia()) ? LocalDate.of(dados.getExercicio().intValue(), dados.getCompetencia().intValue(), 1) : null;
        LocalDate dataFinal = Objects.nonNull(dataInicial) ? dataInicial.with(TemporalAdjusters.lastDayOfMonth()) : dados.getDataFinal();
        Boolean substituir = Objects.nonNull(dados.getSubstituirCargaExistente()) ? dados.getSubstituirCargaExistente() : false;
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$simam$TipoProcessamentoDadosSimAm[dados.getTipoArquivo().ordinal()]) {
            case 1: {
                this.implantacaoSaldoJobStarter.startJob(dados.getEntidade(), dados.getExercicio(), dataFinal);
                break;
            }
            case 2: {
                this.implantacaoSaldoMovimentacaoMensalJobStarter.startJob(dados.getExercicio(), dados.getEntidade());
                break;
            }
            case 3: {
                this.movimentacaoMensalJobStarter.startJob(dataInicial, dataFinal, dados.getEntidade(), dados.getExercicio(), substituir.booleanValue());
                break;
            }
            default: {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Tipo de arquivo n\u00e3o implementado");
            }
        }
    }

    @Generated
    public SimAmGeracaoDadosService(ImplantacaoSaldoJobStarter implantacaoSaldoJobStarter, ImplantacaoSaldoMovimentacaoMensalJobStarter implantacaoSaldoMovimentacaoMensalJobStarter, MovimentacaoMensalJobStarter movimentacaoMensalJobStarter) {
        this.implantacaoSaldoJobStarter = implantacaoSaldoJobStarter;
        this.implantacaoSaldoMovimentacaoMensalJobStarter = implantacaoSaldoMovimentacaoMensalJobStarter;
        this.movimentacaoMensalJobStarter = movimentacaoMensalJobStarter;
    }
}

