/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.cda;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.gateway.client.service.NotificacaoClient;
import br.com.elotech.gateway.dto.DestinoNotificacao;
import br.com.elotech.gateway.dto.Notificacao;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItem;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.LoteCdaResumoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaItemRepository;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemService;
import br.com.elotech.tributos.utils.TenantUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoteCdaService
extends CrudService<LoteCda, Long> {
    private final Logger logger = LoggerFactory.getLogger(LoteCdaService.class);
    private final DebitoRepository debitoRepository;
    private final ContextService contextService;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final LoteCdaRepository loteCdaRepository;
    private final LoteCdaItemRepository loteCdaItemRepository;
    private final LoteCdaItemService loteCdaItemService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final ArquivoClient arquivoClient;
    private final ArquivoClient arquivoClientNovo;
    private final NotificacaoClient notificacaoClient;

    protected void beforeSave(LoteCda entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setChildrenId();
    }

    public void calcularAcrescimosGeracaoCda(LocalDate dataReferencia, List<LoteCdaItem> itens, Long entidade) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        itens.forEach(cda -> cda.getItemDetalhes().forEach(itemDetalhe -> {
            AcrescimoDTO acrescimo = AcrescimoDTO.of((LoteCdaItemDetalhe)itemDetalhe, (Long)formaPagamento.getId());
            acrescimo.setEntidade(entidade);
            acrescimo.setDataReferencia(dataReferencia);
            acrescimo.setCalculaValorDesconto(Boolean.FALSE);
            this.calculoAcrescimoService.calculaAcrescimos(acrescimo, Optional.empty());
            itemDetalhe.setValor(acrescimo.getValor());
            itemDetalhe.setValorMulta(acrescimo.getValorMulta());
            itemDetalhe.setValorJuros(acrescimo.getValorJuros());
            itemDetalhe.setValorCorrecao(acrescimo.getValorCorrecao());
        }));
    }

    public LoteCdaResumoDTO getResumo(Long id) {
        return (LoteCdaResumoDTO)this.loteCdaRepository.getResumo(id).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o lote com id: %d", id)));
    }

    public Page<LoteCdaItem> searchItens(Long id, String search, Pageable pageable) {
        String idClause = String.format("lote.id==%d", id);
        String searchWithIdClause = search.isEmpty() ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), LoteCdaItem.class, (String)searchWithIdClause);
        return this.loteCdaItemRepository.findAll(specification, pageable);
    }

    public LoteCda gerarLoteSimulacao(String filtro) {
        this.validateDebitosNotFound(filtro);
        LoteCda loteCda = new LoteCda();
        loteCda.setDataSimulacao(LocalDate.now());
        loteCda.setSituacao(SituacaoLoteCda.GERANDO_SIMULACAO);
        loteCda.setUsuario(SecurityUtils.getUserAise());
        loteCda.setFiltro(filtro);
        return (LoteCda)this.loteCdaRepository.save((Object)loteCda);
    }

    private void validateDebitosNotFound(String filtro) {
        Long entidade = this.contextService.getEntidadePrincipal();
        if (this.debitoRepository.findDebitosGeracaoCDA(filtro, entidade).isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado nenhum d\u00e9bito para gerar uma certid\u00e3o de d\u00edvida ativa, verifique se os d\u00e9bitos j\u00e1 est\u00e3o inclusos em outras CDA's.");
        }
    }

    public boolean isCdasEmpty(Long idLote) {
        return ((LoteCda)this.loteCdaRepository.findOne((Object)idLote)).getItens().isEmpty();
    }

    public List<BigDecimal> getDebitoParcelaTributoInvalidoFromLoteCda(Long id) {
        return this.loteCdaRepository.findDebitoParcelaTributoInvalidoFromLoteCda(id);
    }

    protected void beforeDelete(LoteCda entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (!this.canDelete(entity)) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover lote com situa\u00e7\u00e3o igual a %s", entity.getSituacao().getDescricao()));
        }
    }

    private boolean canDelete(LoteCda lote) {
        return SituacaoLoteCda.ERRO_SIMULACAO.equals((Object)lote.getSituacao()) || SituacaoLoteCda.SIMULACAO_GERADA.equals((Object)lote.getSituacao());
    }

    @Async
    @Transactional
    public void printCDALoteAgrupado(Long idLoteCda, String search, Sort sort, Integer totalCdas) {
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaImpressaoAgrupadaLoteCDA(idLoteCda);
        Long tarefa = execucao.getTarefaAssincrona().getId();
        String userId = SecurityUtils.getUserId().toString();
        this.sendNotificacao(String.format("Iniciada a gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), tarefa, userId);
        this.groupArquivosLoteCDA(idLoteCda, search, sort, execucao, tarefa, userId, totalCdas);
    }

    private void groupArquivosLoteCDA(Long idLoteCda, String search, Sort sort, TarefaAssincronaExecucao execucao, Long tarefa, String userId, Integer totalCdas) {
        LoteCda loteCda = (LoteCda)this.getEm().getReference(LoteCda.class, (Object)idLoteCda);
        if (Objects.isNull(loteCda)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Lote CDA de id %d.", idLoteCda));
        }
        try {
            this.logger.info("Iniciando o agrupamento dos arquivos de Lote CDA");
            Page loteCdaItens = this.loteCdaItemService.findLoteCdaItem(loteCda.getId(), search, sort, totalCdas);
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequest(loteCda.getId(), loteCdaItens);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            loteCda.setIdArquivoImpressao(arquivo.getId());
            loteCda.setDataImpressao(arquivo.getDataCriacao().toLocalDate());
            loteCda.setUsuarioImpressao(SecurityUtils.getUserAise());
            this.loteCdaRepository.save((Object)loteCda);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.sendNotificacao(String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), tarefa, userId);
            this.logger.info("Finalizado o agrupamento dos arquivos de Lote CDA e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.logger.error("Erro ao agrupar arquivos de Lote CDA {} ", (Object)e.getMessage(), (Object)e);
            this.sendNotificacao(String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), tarefa, userId);
            return;
        }
    }

    private ArquivoNovoRequest getArquivoNovoRequest(Long idLote, Page<LoteCdaItem> loteCdaItens) throws IOException {
        InputStream inputStream = this.mergeArquivosLoteCda(loteCdaItens);
        return this.uploadArquivoAgrupado(idLote, inputStream);
    }

    private ArquivoNovoRequest uploadArquivoAgrupado(Long idLote, InputStream inputStream) {
        String nomeArquivo = String.format("Lote_CDA_Agrupado_Numero_Lote_%d_%s", idLote, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
        return arquivoNovoRequest;
    }

    private InputStream mergeArquivosLoteCda(Page<LoteCdaItem> loteCdaItens) throws IOException {
        PDDocument document = new PDDocument();
        for (LoteCdaItem loteCdaItem : loteCdaItens) {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            byte[] arquivoTemp = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(loteCdaItem.getDocumento().getId());
            PDDocument pdfDocument = PDDocument.load((byte[])arquivoTemp);
            pdfMerge.appendDocument(document, pdfDocument);
            pdfDocument.close();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        document.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private void sendNotificacao(String title, Long tarefa, String userId) {
        Notificacao notificacao = Notificacao.builder().title(title).time(new Date()).tenantId(TenantUtils.getIdentificadorTenant()).destinoNotificacao(DestinoNotificacao.TRIBUTOS).metadata("tipoTarefaAssincrona", (Object)TipoTarefaAssincrona.IMPRESSAO_CDA_LOTE).metadata("tarefa", (Object)tarefa).build();
        this.notificacaoClient.send(notificacao, UUID.fromString(userId));
    }

    public String getUrlArquivoLoteCDA(String idArquivo) {
        try {
            UUID uuid = UUID.fromString(idArquivo);
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + uuid));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception exception) {
            throw new EloValidationException("Falha ao fazer o download no arquivo.");
        }
    }

    private ArquivoClient resolveArquivoClient() {
        return TenantUtils.usesNovoS3() != false ? this.arquivoClientNovo : this.arquivoClient;
    }

    @Generated
    public LoteCdaService(DebitoRepository debitoRepository, ContextService contextService, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, LoteCdaRepository loteCdaRepository, LoteCdaItemRepository loteCdaItemRepository, LoteCdaItemService loteCdaItemService, TarefaAssincronaService tarefaAssincronaService, CertidaoDividaAtivaService certidaoDividaAtivaService, ArquivoClient arquivoClient, ArquivoClient arquivoClientNovo, NotificacaoClient notificacaoClient) {
        this.debitoRepository = debitoRepository;
        this.contextService = contextService;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.loteCdaRepository = loteCdaRepository;
        this.loteCdaItemRepository = loteCdaItemRepository;
        this.loteCdaItemService = loteCdaItemService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.arquivoClient = arquivoClient;
        this.arquivoClientNovo = arquivoClientNovo;
        this.notificacaoClient = notificacaoClient;
    }
}

