/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoEnderecoCorrespondencia;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.repository.EnderecoCorrespondenciaRepository;
import br.com.elotech.tributos.service.PessoaService;
import org.springframework.stereotype.Service;

@Service
public class EnderecoCorrespondenciaService {
    private final EnderecoCorrespondenciaRepository enderecoCorrespondenciaRepository;
    private final PessoaService pessoaService;

    public EnderecoCorrespondenciaService(EnderecoCorrespondenciaRepository enderecoCorrespondenciaRepository, PessoaService pessoaService) {
        this.enderecoCorrespondenciaRepository = enderecoCorrespondenciaRepository;
        this.pessoaService = pessoaService;
    }

    public EnderecoCorrespondenciaDTO findEnderecoCorrespondenciaByIdAndTipo(Long id, TipoEnderecoCorrespondencia tipoEndereco) {
        return this.enderecoCorrespondenciaRepository.findEnderecoCorrespondenciaByIdAndTipo(id, tipoEndereco);
    }

    public EnderecoCorrespondenciaDTO findEnderecoCorrespondenciaPessoa(Long idPessoa) {
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(idPessoa).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrada pessoa com ID %d.", idPessoa)));
        return this.enderecoCorrespondenciaRepository.findEnderecoCorrespondenciaPessoa(pessoa.getId());
    }
}

