/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.tributos.dto.DebitoAgrupadoPorFormaPagamentoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaTributoCotaUnicaDTO;
import br.com.elotech.tributos.repository.DebitoCotaUnicaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.VerificaFormaPagamentoDiferenciadaService;
import br.com.elotech.tributos.util.AgrupaDebitos;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class DebitoCotaUnicaService {
    private final DebitoCotaUnicaRepository debitoCotaUnicaRepository;
    private final ContextService contextService;
    private final VerificaFormaPagamentoDiferenciadaService verificaFormaPagamentoDiferenciadaService;

    public DebitoCotaUnicaService(DebitoCotaUnicaRepository debitoCotaUnicaRepository, ContextService contextService, VerificaFormaPagamentoDiferenciadaService verificaFormaPagamentoDiferenciadaService) {
        this.debitoCotaUnicaRepository = debitoCotaUnicaRepository;
        this.contextService = contextService;
        this.verificaFormaPagamentoDiferenciadaService = verificaFormaPagamentoDiferenciadaService;
    }

    public List<DebitoAgrupadoPorFormaPagamentoDTO> buscaDebitosAgrupadosPorFormaPagamentoDisponivelWeb(Long tipoCadastro, Long cadastroGeral) {
        return AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)this.getDebitoParcelaReceita(tipoCadastro, cadastroGeral)).stream().filter(arg_0 -> ((VerificaFormaPagamentoDiferenciadaService)this.verificaFormaPagamentoDiferenciadaService).podeUtilizarFormaPagamento(arg_0)).collect(Collectors.toList());
    }

    public List<Long> buscaDebitosAgrupadosPorFormaPagamentoDisponivelWeb(List<Long> idsCadastro) {
        Long exercicio = this.contextService.getExercicioAtual();
        EntidadeInfo entidade = this.contextService.getEntidadePrincipalInfo();
        List cadastrosComCarne = this.debitoCotaUnicaRepository.findAllDebitoParcelaReceitaDisponivelWeb(entidade.getId(), exercicio, this.contextService.getDataAtual(), idsCadastro);
        return cadastrosComCarne.stream().map(DebitoParcelaTributoCotaUnicaDTO::getIdCadastro).collect(Collectors.toList());
    }

    public List<DebitoAgrupadoPorFormaPagamentoDTO> buscaPrimeiraCotaUnicaDisponivelWeb(Long tipoCadastro, Long cadastroGeral) {
        List debitosAgrupadosPorFormaPagamentoDTO = this.buscaDebitosAgrupadosPorFormaPagamentoDisponivelWeb(tipoCadastro, cadastroGeral).stream().filter(DebitoAgrupadoPorFormaPagamentoDTO::getIsCotaUnica).collect(Collectors.toList());
        Comparator<DebitoAgrupadoPorFormaPagamentoDTO> vencimentoComparator = Comparator.comparing(DebitoAgrupadoPorFormaPagamentoDTO::getVencimento);
        LocalDate menorVencimentoCotaUnica = debitosAgrupadosPorFormaPagamentoDTO.stream().min(vencimentoComparator).map(DebitoAgrupadoPorFormaPagamentoDTO::getVencimento).orElse(null);
        return debitosAgrupadosPorFormaPagamentoDTO.stream().filter(parcelaReceita -> parcelaReceita.getVencimento().equals(menorVencimentoCotaUnica)).collect(Collectors.toList());
    }

    private List<DebitoParcelaTributoCotaUnicaDTO> getDebitoParcelaReceita(Long tipoCadastro, Long cadastroGeral) {
        Long exercicio = this.contextService.getExercicioAtual();
        EntidadeInfo entidade = this.contextService.getEntidadePrincipalInfo();
        return this.debitoCotaUnicaRepository.findAllDebitoParcelaReceitaDisponivelWeb(entidade.getId(), exercicio, tipoCadastro, cadastroGeral, LocalDate.now());
    }
}

