/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.DividaFormaPagamentoDTO;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.DividaTributoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityNotFoundException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/divida"})
public class DividaResource
extends CrudResource<Divida, Long> {
    private final DividaTributoService dividaTributoService;
    private final FormaPagamentoService formaPagamentoService;
    private final DividaService dividaService;

    public DividaResource(DividaTributoService dividaTributoService, FormaPagamentoService formaPagamentoService, DividaService dividaService) {
        this.dividaTributoService = dividaTributoService;
        this.formaPagamentoService = formaPagamentoService;
        this.dividaService = dividaService;
    }

    @GetMapping(value={"/{id}/tributos"})
    public ResponseEntity<Page<Tributo>> searchDeclaracoesITBIByRequerente(@PathVariable Long id, @RequestParam(required=false, defaultValue="") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.dividaTributoService.findTributosByDividaIdAndRsql(id, search, pageable));
    }

    @GetMapping(value={"/{id}/divida-tributos"})
    public ResponseEntity<List<DividaTributo>> getDividaTributo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.dividaTributoService.findAllByDivida(id));
    }

    @GetMapping(value={"/{id}/divida-tributos/search"})
    public ResponseEntity<Page<DividaTributo>> searchDividaTributo(@PathVariable Long id, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.dividaTributoService.findByDividaIdAndRsql(id, search, pageable));
    }

    @PostMapping(value={"/valida-forma-pagamento"})
    public ResponseEntity<Void> validaFormaPagamentoWeb(@RequestBody DividaFormaPagamentoDTO dividaFormaPagamento) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findOne(dividaFormaPagamento.getFormaPagamento());
        if (Objects.isNull(formaPagamento)) {
            throw new EntityNotFoundException(String.format("Forma de pagamento %d n\u00e3o encontrada.", dividaFormaPagamento.getFormaPagamento()));
        }
        dividaFormaPagamento.setFormaPagamentoEntity(formaPagamento);
        dividaFormaPagamento.toEntity().validaFormaPagamentoWeb();
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<Divida>> findDividaByExercicioAtualAndRsql(@RequestParam String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.dividaService.findDividaByExercicioAtualAndRsql(search, pageable));
    }

    @GetMapping(value={"/byExercicioAndTipo/{exercicio}/{tipoDivida}/calculo"})
    public ResponseEntity<List<Divida>> findByExercicioAndTipoDividaAndWithScriptCalculo(@PathVariable Long exercicio, @PathVariable String tipoDivida) {
        return ResponseEntity.ok((Object)this.dividaService.findByExercicioAndTipoDividaAndWithScriptCalculo(exercicio, TipoDivida.fromValue((String)tipoDivida)));
    }

    @GetMapping(path={"/{id}/resumo"})
    public ResponseEntity<DividaDTO> getDividaResumo(@PathVariable Long id) {
        Divida divida = (Divida)this.dividaService.findById((Serializable)id).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u0101o foi poss\u00edvel encontrar d\u00edvida com o id %d", id)));
        return ResponseEntity.ok((Object)DividaDTO.of((Divida)divida));
    }
}

