/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.imobiliario;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.projection.ImobiliarioAvaliacaoProjection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CadastroImobiliarioRepository
extends CrudRepository<CadastroImobiliario, Long> {
    public CadastroImobiliario findByTipoCadastroAndCadastroGeral(TipoCadastro var1, Long var2);

    public List<CadastroImobiliario> findByPessoaId(Long var1);

    public List<CadastroImobiliario> findByPessoaNome(String var1);

    @Query(value="Select ci from CadastroImobiliario ci where ci.inscricaoCadastral = :inscricao and (:id is null or ci.id != :id)")
    public List<CadastroImobiliario> findDuplicadosByInscricaoCadastralAndId(@Param(value="inscricao") String var1, @Param(value="id") Long var2);

    @Query(value="SELECT  CG.CADASTROGERAL,  AVAL.DATAAVALIACAO,  AVAL.INFORMADOMANUAL,  P.NOME,  AVAL.SEQUENCIA,  AVAL.ValorVenalCondominio,  AVAL.ValorVenalPredial,  AVAL.ValorVenalPredialITBI,  AVAL.ValorVenalTerritorial,  AVAL.ValorVenalTerritorialITBI FROM  TRIBIMOBILIARIOAVALIACAO AVAL  INNER JOIN TRIBCADASTROGERAL CG  ON CG.TIPOCADASTRO = AVAL.TIPOCADASTRO AND CG.CADASTROGERAL = AVAL.CADASTROGERAL  INNER JOIN PESSOA P ON P.PESSOA = CG.PESSOA WHERE AVAL.TIPOCADASTRO = 1  AND AVAL.CADASTROGERAL = :cadastroGeral  AND CG.EXCLUSAOLOGICA = 'N'  AND AVAL.SEQUENCIA = (SELECT MAX(MX.SEQUENCIA)                        FROM                        TRIBIMOBILIARIOAVALIACAO MX                        WHERE MX.TIPOCADASTRO = AVAL.TIPOCADASTRO                          AND MX.CADASTROGERAL = AVAL.CADASTROGERAL)", nativeQuery=true)
    public Stream<ImobiliarioAvaliacaoProjection> findImobiliarioAvaliacao(@Param(value="cadastroGeral") Long var1);

    public Boolean existsByQuadriculaLocalizacaoId(String var1);

    public Boolean existsByLoteamentoId(Long var1);

    public Boolean existsByTestadasLogradouroTestadaId(Long var1);

    @Query(value="select ci from CadastroImobiliario ci where ci.inscricaoCadastral like :inscricaoCadastral||'%'  and (:idAtual is null or ci.id != :idAtual) ")
    public List<CadastroImobiliario> getCadastrosMesmaInscricao(@Param(value="inscricaoCadastral") String var1, @Param(value="idAtual") Long var2);

    @Query(value="Select ci    from CadastroImobiliario ci     where ci.cadastroGeral <> :cadastroGeral       and ci.distritoLocalizacao.distrito = :distritoInscr       and ci.setorLocalizacao.setor = :setorInscr       and ci.quadraLocalizacao.quadra = :quardraInscr       and ci.exclusaoLogica = false       and not exists ( select 1                            from DivisaoUnificacaoLote dul                                join dul.cadastrosImobiliarios cdi                           where cdi.cadastroGeral = :cadastroGeral                              and dul.tipo = br.com.elotech.tributos.domain.TipoDivisaoUnificacaoLote.UNIFICACAO )       and not exists ( select 1                            from DivisaoUnificacaoLote dul                                join dul.cadastrosImobiliarios cdi                           where cdi.cadastroGeral = :cadastroGeral                              and dul.tipo = br.com.elotech.tributos.domain.TipoDivisaoUnificacaoLote.UNIFICACAO )    order by ci.cadastroGeral, ci.tipoCadastro ")
    public List<CadastroImobiliario> getImobiliariosElegiveisUnificacao(@Param(value="cadastroGeral") Long var1, @Param(value="distritoInscr") String var2, @Param(value="setorInscr") String var3, @Param(value="quardraInscr") String var4);
}

